/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.header;

import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodedUrlHeader
implements Header {
    private static Logger log = LoggerFactory.getLogger(CodedUrlHeader.class);
    private final String headerName;
    private final String headerValue;

    public CodedUrlHeader(String string, String string2) {
        this.headerName = string;
        if (!(string2 == null || string2.startsWith("<") && string2.endsWith(">"))) {
            string2 = "<" + string2 + ">";
        }
        this.headerValue = string2;
    }

    @Override
    public String getHeaderName() {
        return this.headerName;
    }

    @Override
    public String getHeaderValue() {
        return this.headerValue;
    }

    public String getCodedUrl() {
        String[] stringArray = this.getCodedUrls();
        return stringArray != null ? stringArray[0] : null;
    }

    public String[] getCodedUrls() {
        String[] stringArray = null;
        if (this.headerValue != null) {
            String[] stringArray2 = this.headerValue.split(",");
            stringArray = new String[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                int n2 = stringArray2[n].indexOf(60);
                if (n2 < 0) {
                    throw new IllegalArgumentException("Invalid CodedURL header value:" + stringArray2[n]);
                }
                int n3 = stringArray2[n].indexOf(62, n2);
                if (n3 < 0) {
                    throw new IllegalArgumentException("Invalid CodedURL header value:" + stringArray2[n]);
                }
                stringArray[n] = stringArray2[n].substring(n2 + 1, n3);
                ++n;
            }
        }
        return stringArray;
    }

    public static CodedUrlHeader parse(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getHeader(string);
        return new CodedUrlHeader(string, string2);
    }
}

