/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlRequestEntity
implements RequestEntity {
    private static Logger log = LoggerFactory.getLogger(XmlRequestEntity.class);
    private final ByteArrayOutputStream xml = new ByteArrayOutputStream();

    public XmlRequestEntity(Document document) throws IOException {
        try {
            DomUtil.transformDocument(document, this.xml);
        }
        catch (TransformerException transformerException) {
            log.error(transformerException.getMessage());
            throw new IOException(transformerException.getMessage());
        }
        catch (SAXException sAXException) {
            log.error(sAXException.getMessage());
            throw new IOException(sAXException.getMessage());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public String getContentType() {
        return "text/xml; charset=UTF-8";
    }

    public void writeRequest(OutputStream outputStream) throws IOException {
        this.xml.writeTo(outputStream);
    }

    public long getContentLength() {
        return this.xml.size();
    }
}

