/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger(ReportMethod.class);
    private final boolean isDeep;

    public ReportMethod(String string, ReportInfo reportInfo) throws IOException {
        super(string);
        DepthHeader depthHeader = new DepthHeader(reportInfo.getDepth());
        this.isDeep = reportInfo.getDepth() > 0;
        this.setRequestHeader(depthHeader);
        this.setRequestBody(reportInfo);
    }

    @Override
    public String getName() {
        return "REPORT";
    }

    @Override
    protected boolean isSuccess(int n) {
        if (this.isDeep) {
            return n == 207;
        }
        return n == 200 || n == 207;
    }
}

