/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.Status;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropPatchMethod
extends DavMethodBase
implements DavConstants {
    private static Logger log = LoggerFactory.getLogger(PropPatchMethod.class);
    private final DavPropertyNameSet propertyNames = new DavPropertyNameSet();
    private DavException responseException;

    public PropPatchMethod(String string, List<? extends PropEntry> list) throws IOException {
        super(string);
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("PROPPATCH cannot be executed without properties to be set or removed.");
        }
        try {
            Document document = DomUtil.createDocument();
            Element element = DomUtil.addChildElement(document, "propertyupdate", NAMESPACE);
            Node node = null;
            boolean bl = false;
            for (PropEntry propEntry : list) {
                DavConstants davConstants;
                if (propEntry instanceof DavPropertyName) {
                    davConstants = (DavPropertyName)propEntry;
                    if (node == null || bl) {
                        bl = false;
                        node = this.getPropElement(element, bl);
                    }
                    node.appendChild(((DavPropertyName)davConstants).toXml(document));
                    this.propertyNames.add((DavPropertyName)davConstants);
                    continue;
                }
                if (propEntry instanceof DavProperty) {
                    davConstants = (DavProperty)propEntry;
                    if (node == null || !bl) {
                        bl = true;
                        node = this.getPropElement(element, bl);
                    }
                    node.appendChild(davConstants.toXml(document));
                    this.propertyNames.add(davConstants.getName());
                    continue;
                }
                throw new IllegalArgumentException("ChangeList may only contain DavPropertyName and DavProperty elements.");
            }
            this.setRequestBody(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    public PropPatchMethod(String string, DavPropertySet davPropertySet, DavPropertyNameSet davPropertyNameSet) throws IOException {
        super(string);
        Object object;
        if (davPropertySet == null || davPropertyNameSet == null) {
            throw new IllegalArgumentException("Neither setProperties nor removeProperties must be null.");
        }
        if (davPropertySet.isEmpty() && davPropertyNameSet.isEmpty()) {
            throw new IllegalArgumentException("Either setProperties or removeProperties can be empty; not both of them.");
        }
        this.propertyNames.addAll(davPropertyNameSet);
        DavPropertyName[] davPropertyNameArray = davPropertySet.getPropertyNames();
        int n = davPropertyNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = davPropertyNameArray[n2];
            this.propertyNames.add((DavPropertyName)object);
            ++n2;
        }
        try {
            object = DomUtil.createDocument();
            Element element = DomUtil.addChildElement((Node)object, "propertyupdate", NAMESPACE);
            if (!davPropertySet.isEmpty()) {
                Element element2 = DomUtil.addChildElement(element, "set", NAMESPACE);
                element2.appendChild(davPropertySet.toXml((Document)object));
            }
            if (!davPropertyNameSet.isEmpty()) {
                Element element3 = DomUtil.addChildElement(element, "remove", NAMESPACE);
                element3.appendChild(davPropertyNameSet.toXml((Document)object));
            }
            this.setRequestBody((Document)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    private Element getPropElement(Element element, boolean bl) {
        Element element2 = DomUtil.addChildElement(element, bl ? "set" : "remove", NAMESPACE);
        return DomUtil.addChildElement(element2, "prop", NAMESPACE);
    }

    @Override
    public String getName() {
        return "PROPPATCH";
    }

    @Override
    protected boolean isSuccess(int n) {
        return n == 207 || n == 200;
    }

    @Override
    protected void processMultiStatusBody(MultiStatus multiStatus, HttpState httpState, HttpConnection httpConnection) {
        MultiStatusResponse[] multiStatusResponseArray = multiStatus.getResponses();
        if (multiStatusResponseArray.length != 1) {
            log.warn("Expected a single multi-status response in PROPPATCH.");
        }
        boolean bl = true;
        int n = 0;
        while (n < 1) {
            Object object;
            Object object2;
            DavPropertyNameSet davPropertyNameSet = multiStatusResponseArray[n].getPropertyNames(200);
            if (davPropertyNameSet.isEmpty()) {
                log.debug("PROPPATCH failed: No 'OK' response found for resource " + multiStatusResponseArray[n].getHref());
                bl = false;
            } else {
                object2 = this.propertyNames.iterator();
                while (object2.hasNext()) {
                    object = object2.nextPropertyName();
                    bl = davPropertyNameSet.remove((DavPropertyName)object);
                }
            }
            if (!davPropertyNameSet.isEmpty()) {
                object2 = new StringBuffer("The following properties outside of the original request where set or removed: ");
                object = davPropertyNameSet.iterator();
                while (object.hasNext()) {
                    ((StringBuffer)object2).append(object.nextPropertyName().toString()).append("; ");
                }
                log.warn(((StringBuffer)object2).toString());
            }
            ++n;
        }
        if (!bl) {
            Status[] statusArray = multiStatusResponseArray[0].getStatus();
            int n2 = 0;
            while (n2 < statusArray.length && this.responseException == null) {
                switch (statusArray[n2].getStatusCode()) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.responseException = new DavException(statusArray[n2].getStatusCode());
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public DavException getResponseException() throws IOException {
        this.checkUsed();
        if (this.getSuccess()) {
            String string = "Cannot retrieve exception from successful response.";
            log.warn(string);
            throw new IllegalStateException(string);
        }
        if (this.responseException != null) {
            return this.responseException;
        }
        return super.getResponseException();
    }
}

