/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropFindMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger(PropFindMethod.class);

    public PropFindMethod(String string) throws IOException {
        this(string, 1, new DavPropertyNameSet(), Integer.MAX_VALUE);
    }

    public PropFindMethod(String string, DavPropertyNameSet davPropertyNameSet, int n) throws IOException {
        this(string, 0, davPropertyNameSet, n);
    }

    public PropFindMethod(String string, int n, int n2) throws IOException {
        this(string, n, new DavPropertyNameSet(), n2);
    }

    public PropFindMethod(String string, int n, DavPropertyNameSet davPropertyNameSet, int n2) throws IOException {
        super(string);
        DepthHeader depthHeader = new DepthHeader(n2);
        this.setRequestHeader(depthHeader.getHeaderName(), depthHeader.getHeaderValue());
        try {
            Document document = DomUtil.createDocument();
            Element element = DomUtil.createElement(document, "propfind", NAMESPACE);
            document.appendChild(element);
            switch (n) {
                case 1: {
                    element.appendChild(DomUtil.createElement(document, "allprop", NAMESPACE));
                    break;
                }
                case 2: {
                    element.appendChild(DomUtil.createElement(document, "propname", NAMESPACE));
                    break;
                }
                case 0: {
                    if (davPropertyNameSet == null) {
                        Element element2 = DomUtil.createElement(document, "prop", NAMESPACE);
                        Element element3 = DomUtil.createElement(document, "resourcetype", NAMESPACE);
                        element2.appendChild(element3);
                        element.appendChild(element2);
                        break;
                    }
                    element.appendChild(davPropertyNameSet.toXml(document));
                    break;
                }
                case 3: {
                    element.appendChild(DomUtil.createElement(document, "allprop", NAMESPACE));
                    if (davPropertyNameSet == null || davPropertyNameSet.isEmpty()) break;
                    Element element4 = DomUtil.createElement(document, "include", NAMESPACE);
                    Element element5 = davPropertyNameSet.toXml(document);
                    Node node = element5.getFirstChild();
                    while (node != null) {
                        element4.appendChild(node.cloneNode(true));
                        node = node.getNextSibling();
                    }
                    element.appendChild(element4);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown propfind type");
                }
            }
            this.setRequestBody(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    @Override
    public String getName() {
        return "PROPFIND";
    }

    @Override
    protected boolean isSuccess(int n) {
        return n == 207;
    }
}

