/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Status
implements DavConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(Status.class);
    private final String version;
    private final int code;
    private final String phrase;

    public Status(int n) {
        this.version = "HTTP/1.1";
        this.code = n;
        this.phrase = DavException.getStatusPhrase(n);
    }

    public Status(String string, int n, String string2) {
        this.version = string;
        this.code = n;
        this.phrase = string2;
    }

    public int getStatusCode() {
        return this.code;
    }

    @Override
    public Element toXml(Document document) {
        String string = String.valueOf(this.version) + " " + this.code + " " + this.phrase;
        Element element = DomUtil.createElement(document, "status", NAMESPACE);
        DomUtil.setText(element, string);
        return element;
    }

    public static Status parse(String string) {
        Status status;
        if (string == null) {
            throw new IllegalArgumentException("Unable to parse status line from null xml element.");
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        try {
            int n4;
            while (Character.isWhitespace(string.charAt(n2))) {
                ++n2;
                ++n3;
            }
            if (!"HTTP".equals(string.substring(n2, n2 += 4))) {
                log.warn("Status-Line '" + string + "' does not start with HTTP");
            }
            if ((n2 = string.indexOf(32, n2)) <= 0) {
                log.warn("Unable to parse HTTP-Version from the status line: '" + string + "'");
            }
            String string2 = string.substring(n3, n2).toUpperCase();
            while (string.charAt(n2) == ' ') {
                ++n2;
            }
            int n5 = string.indexOf(32, n2);
            if (n5 < 0) {
                n5 = n;
            }
            try {
                n4 = Integer.parseInt(string.substring(n2, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unable to parse status code from status line: '" + string + "'");
            }
            String string3 = "";
            n2 = n5 + 1;
            if (n2 < n) {
                string3 = string.substring(n2).trim();
            }
            status = new Status(string2, n4, string3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Status-Line '" + string + "' is not valid");
        }
        return status;
    }
}

