/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.Status;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.PropContainer;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MultiStatusResponse
implements XmlSerializable,
DavConstants {
    private static final int TYPE_PROPSTAT = 0;
    private static final int TYPE_HREFSTATUS = 1;
    private final int type;
    private final String href;
    private final String responseDescription;
    private Status status;
    private HashMap<Integer, PropContainer> statusMap;

    private MultiStatusResponse(String string, String string2, int n) {
        this.statusMap = new HashMap();
        if (!MultiStatusResponse.isValidHref(string)) {
            throw new IllegalArgumentException("Invalid href ('" + string + "')");
        }
        this.href = string;
        this.responseDescription = string2;
        this.type = n;
    }

    public MultiStatusResponse(String string, Status status, String string2) {
        this(string, string2, 1);
        if (status == null) {
            throw new IllegalArgumentException("Status must not be null in case of a multistatus reponse that consists of href + status only.");
        }
        this.status = status;
    }

    public MultiStatusResponse(String string, int n) {
        this(string, n, null);
    }

    public MultiStatusResponse(String string, int n, String string2) {
        this(string, new Status(n), string2);
    }

    public MultiStatusResponse(String string, String string2) {
        this(string, string2, 0);
    }

    public MultiStatusResponse(DavResource davResource, DavPropertyNameSet davPropertyNameSet) {
        this(davResource, davPropertyNameSet, 0);
    }

    /*
     * WARNING - void declaration
     */
    public MultiStatusResponse(DavResource davResource, DavPropertyNameSet davPropertyNameSet, int n) {
        block9: {
            block8: {
                void var6_19;
                this(davResource.getHref(), null, 0);
                if (n != 2) break block8;
                PropContainer propContainer = this.getPropContainer(200, true);
                DavPropertyName[] davPropertyNameArray = davResource.getPropertyNames();
                int n2 = davPropertyNameArray.length;
                boolean bl = false;
                while (var6_19 < n2) {
                    DavPropertyName davPropertyName = davPropertyNameArray[var6_19];
                    propContainer.addContent(davPropertyName);
                    ++var6_19;
                }
                break block9;
            }
            PropContainer propContainer = this.getPropContainer(200, false);
            HashSet<DavPropertyName> hashSet = new HashSet<DavPropertyName>(davPropertyNameSet.getContent());
            if (n == 0) {
                for (DavPropertyName davPropertyName : davPropertyNameSet) {
                    DavProperty<?> davProperty = davResource.getProperty(davPropertyName);
                    if (davProperty == null) continue;
                    propContainer.addContent(davProperty);
                    hashSet.remove(davPropertyName);
                }
            } else {
                for (DavProperty davProperty : davResource.getProperties()) {
                    boolean bl = n == 1 || n == 3;
                    boolean bl2 = hashSet.remove(davProperty.getName());
                    if ((!bl || davProperty.isInvisibleInAllprop()) && !bl2) continue;
                    propContainer.addContent(davProperty);
                }
                if (n == 3 && !hashSet.isEmpty()) {
                    for (DavPropertyName davPropertyName : new HashSet<DavPropertyName>(hashSet)) {
                        DavProperty<?> davProperty = davResource.getProperty(davPropertyName);
                        if (davProperty == null) continue;
                        propContainer.addContent(davProperty);
                        hashSet.remove(davPropertyName);
                    }
                }
            }
            if (hashSet.isEmpty() || n == 1) break block9;
            PropContainer propContainer2 = this.getPropContainer(404, true);
            for (DavPropertyName davPropertyName : hashSet) {
                propContainer2.addContent(davPropertyName);
            }
        }
    }

    public String getHref() {
        return this.href;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }

    public Status[] getStatus() {
        Status[] statusArray;
        if (this.type == 0) {
            statusArray = new Status[this.statusMap.size()];
            Iterator<Integer> iterator = this.statusMap.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Integer n2 = iterator.next();
                statusArray[n] = new Status(n2);
                ++n;
            }
        } else {
            statusArray = new Status[]{this.status};
        }
        return statusArray;
    }

    @Override
    public Element toXml(Document document) {
        Element element = DomUtil.createElement(document, "response", NAMESPACE);
        element.appendChild(DomUtil.hrefToXml(this.getHref(), document));
        if (this.type == 0) {
            for (Integer object2 : this.statusMap.keySet()) {
                Status status = new Status(object2);
                PropContainer propContainer = this.statusMap.get(object2);
                if (propContainer.isEmpty()) continue;
                Element element2 = DomUtil.createElement(document, "propstat", NAMESPACE);
                element2.appendChild(propContainer.toXml(document));
                element2.appendChild(status.toXml(document));
                element.appendChild(element2);
            }
        } else {
            element.appendChild(this.status.toXml(document));
        }
        String string = this.getResponseDescription();
        if (string != null) {
            Element element3 = DomUtil.createElement(document, "responsedescription", NAMESPACE);
            DomUtil.setText(element3, string);
            element.appendChild(element3);
        }
        return element;
    }

    public void add(DavProperty<?> davProperty) {
        this.checkType(0);
        PropContainer propContainer = this.getPropContainer(200, false);
        propContainer.addContent(davProperty);
    }

    public void add(DavPropertyName davPropertyName) {
        this.checkType(0);
        PropContainer propContainer = this.getPropContainer(200, true);
        propContainer.addContent(davPropertyName);
    }

    public void add(DavProperty<?> davProperty, int n) {
        this.checkType(0);
        PropContainer propContainer = this.getPropContainer(n, false);
        propContainer.addContent(davProperty);
    }

    public void add(DavPropertyName davPropertyName, int n) {
        this.checkType(0);
        PropContainer propContainer = this.getPropContainer(n, true);
        propContainer.addContent(davPropertyName);
    }

    private PropContainer getPropContainer(int n, boolean bl) {
        PropContainer propContainer = this.statusMap.get(n);
        if (propContainer == null) {
            propContainer = bl ? new DavPropertyNameSet() : new DavPropertySet();
            this.statusMap.put(n, propContainer);
        }
        return propContainer;
    }

    private void checkType(int n) {
        if (this.type != n) {
            throw new IllegalStateException("The given MultiStatusResponse is not of the required type.");
        }
    }

    public DavPropertySet getProperties(int n) {
        PropContainer propContainer;
        if (this.statusMap.containsKey(n) && (propContainer = this.statusMap.get(n)) != null && propContainer instanceof DavPropertySet) {
            return (DavPropertySet)propContainer;
        }
        return new DavPropertySet();
    }

    public DavPropertyNameSet getPropertyNames(int n) {
        PropContainer propContainer;
        if (this.statusMap.containsKey(n) && (propContainer = this.statusMap.get(n)) != null) {
            if (propContainer instanceof DavPropertySet) {
                DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
                DavPropertyName[] davPropertyNameArray = ((DavPropertySet)propContainer).getPropertyNames();
                int n2 = davPropertyNameArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    DavPropertyName davPropertyName = davPropertyNameArray[n3];
                    davPropertyNameSet.add(davPropertyName);
                    ++n3;
                }
                return davPropertyNameSet;
            }
            return (DavPropertyNameSet)propContainer;
        }
        return new DavPropertyNameSet();
    }

    public static MultiStatusResponse createFromXml(Element element) {
        MultiStatusResponse multiStatusResponse;
        if (!DomUtil.matches(element, "response", NAMESPACE)) {
            throw new IllegalArgumentException("DAV:response element required.");
        }
        String string = DomUtil.getChildTextTrim(element, "href", NAMESPACE);
        if (string == null) {
            throw new IllegalArgumentException("DAV:response element must contain a DAV:href element expected.");
        }
        String string2 = DomUtil.getChildText(element, "status", NAMESPACE);
        String string3 = DomUtil.getChildText(element, "responsedescription", NAMESPACE);
        if (string2 != null) {
            Status status = Status.parse(string2);
            multiStatusResponse = new MultiStatusResponse(string, status, string3);
        } else {
            multiStatusResponse = new MultiStatusResponse(string, string3, 0);
            ElementIterator elementIterator = DomUtil.getChildren(element, "propstat", NAMESPACE);
            while (elementIterator.hasNext()) {
                Element element2 = elementIterator.nextElement();
                String string4 = DomUtil.getChildText(element2, "status", NAMESPACE);
                Element element3 = DomUtil.getChildElement(element2, "prop", NAMESPACE);
                if (string4 == null || element3 == null) continue;
                int n = Status.parse(string4).getStatusCode();
                ElementIterator elementIterator2 = DomUtil.getChildren(element3);
                while (elementIterator2.hasNext()) {
                    Element element4 = elementIterator2.nextElement();
                    DefaultDavProperty<?> defaultDavProperty = DefaultDavProperty.createFromXml(element4);
                    multiStatusResponse.add(defaultDavProperty, n);
                }
            }
        }
        return multiStatusResponse;
    }

    private static boolean isValidHref(String string) {
        return string != null && !"".equals(string);
    }
}

