/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultiStatus
implements DavConstants,
XmlSerializable {
    private Map<String, MultiStatusResponse> responses = new LinkedHashMap<String, MultiStatusResponse>();
    private String responseDescription;

    public void addResourceProperties(DavResource davResource, DavPropertyNameSet davPropertyNameSet, int n, int n2) {
        this.addResponse(new MultiStatusResponse(davResource, davPropertyNameSet, n));
        if (n2 > 0 && davResource.isCollection()) {
            DavResourceIterator davResourceIterator = davResource.getMembers();
            while (davResourceIterator.hasNext()) {
                this.addResourceProperties(davResourceIterator.nextResource(), davPropertyNameSet, n, n2 - 1);
            }
        }
    }

    public void addResourceProperties(DavResource davResource, DavPropertyNameSet davPropertyNameSet, int n) {
        this.addResourceProperties(davResource, davPropertyNameSet, 0, n);
    }

    public void addResourceStatus(DavResource davResource, int n, int n2) {
        this.addResponse(new MultiStatusResponse(davResource.getHref(), n));
        if (n2 > 0 && davResource.isCollection()) {
            DavResourceIterator davResourceIterator = davResource.getMembers();
            while (davResourceIterator.hasNext()) {
                this.addResourceStatus(davResourceIterator.nextResource(), n, n2 - 1);
            }
        }
    }

    public synchronized void addResponse(MultiStatusResponse multiStatusResponse) {
        this.responses.put(multiStatusResponse.getHref(), multiStatusResponse);
    }

    public synchronized MultiStatusResponse[] getResponses() {
        return this.responses.values().toArray(new MultiStatusResponse[this.responses.size()]);
    }

    public void setResponseDescription(String string) {
        this.responseDescription = string;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }

    @Override
    public Element toXml(Document document) {
        Object object;
        Element element = DomUtil.createElement(document, "multistatus", NAMESPACE);
        MultiStatusResponse[] multiStatusResponseArray = this.getResponses();
        int n = multiStatusResponseArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = multiStatusResponseArray[n2];
            element.appendChild(((MultiStatusResponse)object).toXml(document));
            ++n2;
        }
        if (this.responseDescription != null) {
            object = DomUtil.createElement(document, "responsedescription", NAMESPACE, this.responseDescription);
            element.appendChild((Node)object);
        }
        return element;
    }

    public static MultiStatus createFromXml(Element element) {
        if (!DomUtil.matches(element, "multistatus", NAMESPACE)) {
            throw new IllegalArgumentException("DAV:multistatus element expected.");
        }
        MultiStatus multiStatus = new MultiStatus();
        ElementIterator elementIterator = DomUtil.getChildren(element, "response", NAMESPACE);
        while (elementIterator.hasNext()) {
            Element element2 = elementIterator.nextElement();
            MultiStatusResponse multiStatusResponse = MultiStatusResponse.createFromXml(element2);
            multiStatus.addResponse(multiStatusResponse);
        }
        multiStatus.setResponseDescription(DomUtil.getChildText(element, "responsedescription", NAMESPACE));
        return multiStatus;
    }
}

