/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DavException
extends Exception
implements XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(DavException.class);
    private static Properties statusPhrases = new Properties();
    public static final String XML_ERROR = "error";
    private int errorCode = 500;
    private Element errorCondition;

    static {
        try {
            InputStream inputStream = DavException.class.getResourceAsStream("statuscode.properties");
            if (inputStream == null) {
                throw new IOException("Couldn't find statuscode.properties");
            }
            statusPhrases.load(inputStream);
        }
        catch (Exception exception) {
            log.error("Failed to load status properties: " + exception.getMessage());
        }
    }

    public DavException(int n, String string) {
        this(n, string, null, null);
    }

    public DavException(int n, Throwable throwable) {
        this(n, null, throwable, null);
    }

    public DavException(int n) {
        this(n, statusPhrases.getProperty(String.valueOf(n)), null, null);
    }

    public DavException(int n, String string, Throwable throwable, Element element) {
        super(string, throwable);
        this.errorCode = n;
        this.errorCondition = element;
        log.debug("DavException: (" + n + ") " + string);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getStatusPhrase() {
        return DavException.getStatusPhrase(this.errorCode);
    }

    public static String getStatusPhrase(int n) {
        return statusPhrases.getProperty(String.valueOf(n));
    }

    public boolean hasErrorCondition() {
        return this.errorCondition != null;
    }

    @Override
    public Element toXml(Document document) {
        if (this.hasErrorCondition()) {
            Element element;
            if (DomUtil.matches(this.errorCondition, XML_ERROR, DavConstants.NAMESPACE)) {
                element = (Element)document.importNode(this.errorCondition, true);
            } else {
                element = DomUtil.createElement(document, XML_ERROR, DavConstants.NAMESPACE);
                element.appendChild(document.importNode(this.errorCondition, true));
            }
            return element;
        }
        return null;
    }
}

