/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;

public final class UserAuthenticatorUtils {
    private UserAuthenticatorUtils() {
    }

    public static char[] getData(UserAuthenticationData userAuthenticationData, UserAuthenticationData.Type type, char[] cArray) {
        if (cArray != null) {
            return cArray;
        }
        if (userAuthenticationData == null) {
            return null;
        }
        return userAuthenticationData.getData(type);
    }

    public static UserAuthenticationData authenticate(FileSystemOptions fileSystemOptions, UserAuthenticationData.Type[] typeArray) {
        UserAuthenticator userAuthenticator = DefaultFileSystemConfigBuilder.getInstance().getUserAuthenticator(fileSystemOptions);
        return UserAuthenticatorUtils.authenticate(userAuthenticator, typeArray);
    }

    public static UserAuthenticationData authenticate(UserAuthenticator userAuthenticator, UserAuthenticationData.Type[] typeArray) {
        if (userAuthenticator == null) {
            return null;
        }
        return userAuthenticator.requestAuthentication(typeArray);
    }

    public static char[] toChar(String string) {
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    public static void cleanup(UserAuthenticationData userAuthenticationData) {
        if (userAuthenticationData == null) {
            return;
        }
        userAuthenticationData.cleanup();
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return new String(cArray);
    }
}

