/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.vfs2.util.OsFamily;

public final class Os {
    public static final OsFamily OS_FAMILY_WINDOWS = new OsFamily("windows");
    public static final OsFamily OS_FAMILY_DOS = new OsFamily("dos");
    public static final OsFamily OS_FAMILY_WINNT = new OsFamily("nt", new OsFamily[]{OS_FAMILY_WINDOWS});
    public static final OsFamily OS_FAMILY_WIN9X = new OsFamily("win9x", new OsFamily[]{OS_FAMILY_WINDOWS, OS_FAMILY_DOS});
    public static final OsFamily OS_FAMILY_OS2 = new OsFamily("os/2", new OsFamily[]{OS_FAMILY_DOS});
    public static final OsFamily OS_FAMILY_NETWARE = new OsFamily("netware");
    public static final OsFamily OS_FAMILY_UNIX = new OsFamily("unix");
    public static final OsFamily OS_FAMILY_MAC = new OsFamily("mac");
    public static final OsFamily OS_FAMILY_OSX = new OsFamily("osx", new OsFamily[]{OS_FAMILY_UNIX, OS_FAMILY_MAC});
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private static final OsFamily OS_FAMILY;
    private static final OsFamily[] OS_ALL_FAMILIES;
    private static final OsFamily[] ALL_FAMILIES;

    static {
        ALL_FAMILIES = new OsFamily[]{OS_FAMILY_DOS, OS_FAMILY_MAC, OS_FAMILY_NETWARE, OS_FAMILY_OS2, OS_FAMILY_OSX, OS_FAMILY_UNIX, OS_FAMILY_WINDOWS, OS_FAMILY_WINNT, OS_FAMILY_WIN9X};
        OS_FAMILY = Os.determineOsFamily();
        OS_ALL_FAMILIES = Os.determineAllFamilies();
    }

    private Os() {
    }

    public static boolean isVersion(String string) {
        return Os.isOs(null, null, null, string);
    }

    public static boolean isArch(String string) {
        return Os.isOs(null, null, string, null);
    }

    public static boolean isFamily(String string) {
        return Os.isOs(string, null, null, null);
    }

    public static boolean isFamily(OsFamily osFamily) {
        return Os.isOs(osFamily, null, null, null);
    }

    public static boolean isName(String string) {
        return Os.isOs(null, string, null, null);
    }

    public static boolean isOs(String string, String string2, String string3, String string4) {
        return Os.isOs(Os.getFamily(string), string2, string3, string4);
    }

    public static boolean isOs(OsFamily osFamily, String string, String string2, String string3) {
        if (osFamily != null || string != null || string2 != null || string3 != null) {
            boolean bl = Os.familyMatches(osFamily);
            boolean bl2 = Os.nameMatches(string);
            boolean bl3 = Os.archMatches(string2);
            boolean bl4 = Os.versionMatches(string3);
            return bl && bl2 && bl3 && bl4;
        }
        return false;
    }

    public static OsFamily getFamily(String string) {
        int n = 0;
        while (n < ALL_FAMILIES.length) {
            OsFamily osFamily = ALL_FAMILIES[n];
            if (osFamily.getName().equalsIgnoreCase(string)) {
                return osFamily;
            }
            ++n;
        }
        return null;
    }

    private static boolean versionMatches(String string) {
        boolean bl = true;
        if (string != null) {
            bl = string.equalsIgnoreCase(OS_VERSION);
        }
        return bl;
    }

    private static boolean archMatches(String string) {
        boolean bl = true;
        if (string != null) {
            bl = string.equalsIgnoreCase(OS_ARCH);
        }
        return bl;
    }

    private static boolean nameMatches(String string) {
        boolean bl = true;
        if (string != null) {
            bl = string.equalsIgnoreCase(OS_NAME);
        }
        return bl;
    }

    private static boolean familyMatches(OsFamily osFamily) {
        if (osFamily == null) {
            return false;
        }
        int n = 0;
        while (n < OS_ALL_FAMILIES.length) {
            OsFamily osFamily2 = OS_ALL_FAMILIES[n];
            if (osFamily == osFamily2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static OsFamily[] determineAllFamilies() {
        HashSet<OsFamily> hashSet = new HashSet<OsFamily>();
        if (OS_FAMILY != null) {
            ArrayList<OsFamily> arrayList = new ArrayList<OsFamily>();
            arrayList.add(OS_FAMILY);
            while (arrayList.size() > 0) {
                OsFamily osFamily = (OsFamily)arrayList.remove(0);
                hashSet.add(osFamily);
                OsFamily[] osFamilyArray = osFamily.getFamilies();
                int n = 0;
                while (n < osFamilyArray.length) {
                    OsFamily osFamily2 = osFamilyArray[n];
                    arrayList.add(osFamily2);
                    ++n;
                }
            }
        }
        return hashSet.toArray(new OsFamily[hashSet.size()]);
    }

    private static OsFamily determineOsFamily() {
        if (OS_NAME.indexOf("windows") > -1) {
            if (OS_NAME.indexOf("xp") > -1 || OS_NAME.indexOf("2000") > -1 || OS_NAME.indexOf("nt") > -1) {
                return OS_FAMILY_WINNT;
            }
            return OS_FAMILY_WIN9X;
        }
        if (OS_NAME.indexOf("os/2") > -1) {
            return OS_FAMILY_OS2;
        }
        if (OS_NAME.indexOf("netware") > -1) {
            return OS_FAMILY_NETWARE;
        }
        if (OS_NAME.indexOf("mac") > -1) {
            if (OS_NAME.endsWith("x")) {
                return OS_FAMILY_OSX;
            }
            return OS_FAMILY_MAC;
        }
        if (PATH_SEP.equals(":")) {
            return OS_FAMILY_UNIX;
        }
        return null;
    }
}

