/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.util.CombinedResources;

public final class Messages {
    private static ConcurrentMap<String, MessageFormat> messages = new ConcurrentHashMap<String, MessageFormat>();
    private static ResourceBundle resources;

    private Messages() {
    }

    public static String getString(String string) {
        return Messages.getString(string, new Object[0]);
    }

    public static String getString(String string, Object object) {
        return Messages.getString(string, new Object[]{object});
    }

    public static String getString(String string, Object[] objectArray) {
        block3: {
            try {
                if (string != null) break block3;
                return null;
            }
            catch (MissingResourceException missingResourceException) {
                return "Unknown message with code \"" + string + "\".";
            }
        }
        MessageFormat messageFormat = Messages.findMessage(string);
        return messageFormat.format(objectArray);
    }

    private static MessageFormat findMessage(String string) throws MissingResourceException {
        MessageFormat messageFormat = (MessageFormat)messages.get(string);
        if (messageFormat != null) {
            return messageFormat;
        }
        if (resources == null) {
            resources = new CombinedResources("org.apache.commons.vfs2.Resources");
        }
        String string2 = resources.getString(string);
        messageFormat = new MessageFormat(string2);
        messages.putIfAbsent(string, messageFormat);
        return (MessageFormat)messages.get(string);
    }
}

