/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.util.Messages;

public class DelegatingFileSystemOptionsBuilder {
    private static final Class<String>[] STRING_PARAM = new Class[]{String.class};
    private static final Map<String, Class<?>> PRIMATIVE_TO_OBJECT = new TreeMap();
    private final Log log = LogFactory.getLog(DelegatingFileSystemOptionsBuilder.class);
    private final FileSystemManager manager;
    private final Map<String, Map<String, List<Method>>> beanMethods = new TreeMap<String, Map<String, List<Method>>>();

    static {
        PRIMATIVE_TO_OBJECT.put(Void.TYPE.getName(), Void.class);
        PRIMATIVE_TO_OBJECT.put(Boolean.TYPE.getName(), Boolean.class);
        PRIMATIVE_TO_OBJECT.put(Byte.TYPE.getName(), Byte.class);
        PRIMATIVE_TO_OBJECT.put(Character.TYPE.getName(), Character.class);
        PRIMATIVE_TO_OBJECT.put(Short.TYPE.getName(), Short.class);
        PRIMATIVE_TO_OBJECT.put(Integer.TYPE.getName(), Integer.class);
        PRIMATIVE_TO_OBJECT.put(Long.TYPE.getName(), Long.class);
        PRIMATIVE_TO_OBJECT.put(Double.TYPE.getName(), Double.class);
        PRIMATIVE_TO_OBJECT.put(Float.TYPE.getName(), Float.class);
    }

    public DelegatingFileSystemOptionsBuilder(FileSystemManager fileSystemManager) {
        this.manager = fileSystemManager;
    }

    protected FileSystemManager getManager() {
        return this.manager;
    }

    public void setConfigString(FileSystemOptions fileSystemOptions, String string, String string2, String string3) throws FileSystemException {
        this.setConfigStrings(fileSystemOptions, string, string2, new String[]{string3});
    }

    public void setConfigStrings(FileSystemOptions fileSystemOptions, String string, String string2, String[] stringArray) throws FileSystemException {
        Context context = new Context(fileSystemOptions, string, string2, stringArray);
        this.setValues(context);
    }

    public void setConfigClass(FileSystemOptions fileSystemOptions, String string, String string2, Class<?> clazz) throws FileSystemException, IllegalAccessException, InstantiationException {
        this.setConfigClasses(fileSystemOptions, string, string2, new Class[]{clazz});
    }

    public void setConfigClasses(FileSystemOptions fileSystemOptions, String string, String string2, Class<?>[] classArray) throws FileSystemException, IllegalAccessException, InstantiationException {
        Object[] objectArray = new Object[classArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = classArray[n].newInstance();
            ++n;
        }
        Context context = new Context(fileSystemOptions, string, string2, objectArray);
        this.setValues(context);
    }

    private void setValues(Context context) throws FileSystemException {
        if (!this.fillConfigSetters(context)) {
            throw new FileSystemException("vfs.provider/config-key-invalid.error", new String[]{context.scheme, context.name});
        }
        context.fileSystemConfigBuilder = this.getManager().getFileSystemConfigBuilder(context.scheme);
        for (Method method : context.configSetters) {
            if (!this.convertValuesAndInvoke(method, context)) continue;
            return;
        }
        throw new FileSystemException("vfs.provider/config-value-invalid.error", new Object[]{context.scheme, context.name, context.values});
    }

    private boolean convertValuesAndInvoke(Method method, Context context) throws FileSystemException {
        Method method2;
        Constructor<?> constructor;
        Class<?> clazz;
        Class<?> clazz2;
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length < 2) {
            return false;
        }
        if (!classArray[0].isAssignableFrom(FileSystemOptions.class)) {
            return false;
        }
        Class<?> clazz3 = classArray[1];
        if (clazz3.isArray()) {
            clazz2 = clazz3.getComponentType();
        } else {
            if (context.values.length > 1) {
                return false;
            }
            clazz2 = clazz3;
        }
        if (clazz2.isPrimitive()) {
            clazz = PRIMATIVE_TO_OBJECT.get(clazz2.getName());
            if (clazz == null) {
                this.log.warn((Object)Messages.getString("vfs.provider/config-unexpected-primitive.error", clazz2.getName()));
                return false;
            }
            clazz2 = clazz;
        }
        if (clazz2.isAssignableFrom(clazz = context.values[0].getClass())) {
            this.invokeSetter(clazz3, context, method, context.values);
            return true;
        }
        if (clazz != String.class) {
            this.log.warn((Object)Messages.getString("vfs.provider/config-unexpected-value-class.error", new String[]{clazz.getName(), context.scheme, context.name}));
            return false;
        }
        Object object = Array.newInstance(clazz2, context.values.length);
        try {
            constructor = clazz2.getConstructor(STRING_PARAM);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            constructor = null;
        }
        if (constructor != null) {
            int n = 0;
            while (n < context.values.length) {
                try {
                    Array.set(object, n, constructor.newInstance(context.values[n]));
                }
                catch (InstantiationException instantiationException) {
                    throw new FileSystemException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new FileSystemException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new FileSystemException(invocationTargetException);
                }
                ++n;
            }
            this.invokeSetter(clazz3, context, method, object);
            return true;
        }
        try {
            method2 = clazz2.getMethod("valueOf", STRING_PARAM);
            if (!Modifier.isStatic(method2.getModifiers())) {
                method2 = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method2 = null;
        }
        if (method2 != null) {
            int n = 0;
            while (n < context.values.length) {
                try {
                    Array.set(object, n, method2.invoke(null, context.values[n]));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new FileSystemException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new FileSystemException(invocationTargetException);
                }
                ++n;
            }
            this.invokeSetter(clazz3, context, method, object);
            return true;
        }
        return false;
    }

    private void invokeSetter(Class<?> clazz, Context context, Method method, Object object) throws FileSystemException {
        Object[] objectArray = clazz.isArray() ? new Object[]{context.fso, object} : new Object[]{context.fso, Array.get(object, 0)};
        try {
            method.invoke((Object)context.fileSystemConfigBuilder, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FileSystemException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FileSystemException(invocationTargetException);
        }
    }

    private boolean fillConfigSetters(Context context) throws FileSystemException {
        Map<String, List<Method>> map = this.getSchemeMethods(context.scheme);
        List<Method> list = map.get(context.name.toLowerCase());
        if (list == null) {
            return false;
        }
        context.configSetters = list;
        return true;
    }

    private Map<String, List<Method>> getSchemeMethods(String string) throws FileSystemException {
        Map<String, List<Method>> map = this.beanMethods.get(string);
        if (map == null) {
            map = this.createSchemeMethods(string);
            this.beanMethods.put(string, map);
        }
        return map;
    }

    private Map<String, List<Method>> createSchemeMethods(String string) throws FileSystemException {
        FileSystemConfigBuilder fileSystemConfigBuilder = this.getManager().getFileSystemConfigBuilder(string);
        if (fileSystemConfigBuilder == null) {
            throw new FileSystemException("vfs.provider/no-config-builder.error", string);
        }
        TreeMap<String, List<Method>> treeMap = new TreeMap<String, List<Method>>();
        Method[] methodArray = fileSystemConfigBuilder.getClass().getMethods();
        int n = 0;
        while (n < methodArray.length) {
            String string2;
            Method method = methodArray[n];
            if (Modifier.isPublic(method.getModifiers()) && (string2 = method.getName()).startsWith("set")) {
                String string3 = string2.substring(3).toLowerCase();
                ArrayList<Method> arrayList = (ArrayList<Method>)treeMap.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<Method>(2);
                    treeMap.put(string3, arrayList);
                }
                arrayList.add(method);
            }
            ++n;
        }
        return treeMap;
    }

    private static final class Context {
        private final FileSystemOptions fso;
        private final String scheme;
        private final String name;
        private final Object[] values;
        private List<Method> configSetters;
        private FileSystemConfigBuilder fileSystemConfigBuilder;

        private Context(FileSystemOptions fileSystemOptions, String string, String string2, Object[] objectArray) {
            this.fso = fileSystemOptions;
            this.scheme = string;
            this.name = string2;
            this.values = objectArray;
        }
    }
}

