/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import org.apache.commons.vfs2.util.Cryptor;
import org.apache.commons.vfs2.util.DefaultCryptor;

public final class CryptorFactory {
    public static final String CRYPTOR_CLASS = "org.apache.commons.vfs2.cryptor";
    private static Cryptor instance;

    private CryptorFactory() {
    }

    public static synchronized void setCryptor(Cryptor cryptor) {
        instance = cryptor;
    }

    public static synchronized Cryptor getCryptor() {
        if (instance != null) {
            return instance;
        }
        String string = System.getProperty(CRYPTOR_CLASS);
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                instance = (Cryptor)clazz.newInstance();
                return instance;
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to create Cryptor " + string, exception);
            }
        }
        instance = new DefaultCryptor();
        return instance;
    }
}

