/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class CombinedResources
extends ResourceBundle {
    private final String resourceName;
    private boolean inited;
    private final Properties properties = new Properties();

    public CombinedResources(String string) {
        this.resourceName = string;
    }

    protected void init() {
        if (this.inited) {
            return;
        }
        this.loadResources(this.getResourceName());
        this.loadResources(Locale.getDefault());
        this.loadResources(this.getLocale());
        this.inited = true;
    }

    protected void loadResources(Locale locale) {
        if (locale == null) {
            return;
        }
        String[] stringArray = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < 3) {
            stringBuilder.append(this.getResourceName());
            int n2 = 0;
            while (n2 < n) {
                stringBuilder.append('_').append(stringArray[n2]);
                ++n2;
            }
            if (stringArray[n].length() != 0) {
                stringBuilder.append('_').append(stringArray[n]);
                this.loadResources(stringBuilder.toString());
            }
            stringBuilder.setLength(0);
            ++n;
        }
    }

    protected void loadResources(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        string = String.valueOf(string.replace('.', '/')) + ".properties";
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                try {
                    this.properties.load(uRL.openConnection().getInputStream());
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {}
    }

    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public Enumeration<String> getKeys() {
        if (!this.inited) {
            this.init();
        }
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return CombinedResources.this.properties.keys().hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)CombinedResources.this.properties.keys().nextElement();
            }
        };
    }

    @Override
    protected Object handleGetObject(String string) {
        if (!this.inited) {
            this.init();
        }
        return this.properties.get(string);
    }
}

