/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;

public class ZipFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(ZipFileSystem.class);
    private final File file;
    private ZipFile zipFile;

    public ZipFileSystem(AbstractFileName abstractFileName, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(abstractFileName, fileObject, fileSystemOptions);
        this.file = fileObject.getFileSystem().replicateFile(fileObject, Selectors.SELECT_SELF, null);
        if (!this.file.exists()) {
            this.zipFile = null;
            return;
        }
    }

    @Override
    public void init() throws FileSystemException {
        super.init();
        try {
            ArrayList<ZipFileObject> arrayList = new ArrayList<ZipFileObject>(100);
            Enumeration<? extends ZipEntry> enumeration = this.getZipFile().entries();
            while (enumeration.hasMoreElements()) {
                ZipFileObject zipFileObject;
                ZipEntry zipEntry = enumeration.nextElement();
                AbstractFileName abstractFileName = (AbstractFileName)this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(zipEntry.getName()));
                if (zipEntry.isDirectory() && this.getFileFromCache(abstractFileName) != null) {
                    zipFileObject = (ZipFileObject)this.getFileFromCache(abstractFileName);
                    zipFileObject.setZipEntry(zipEntry);
                    continue;
                }
                zipFileObject = this.createZipFileObject(abstractFileName, zipEntry);
                this.putFileToCache(zipFileObject);
                arrayList.add(zipFileObject);
                zipFileObject.holdObject(arrayList);
                AbstractFileName abstractFileName2 = (AbstractFileName)abstractFileName.getParent();
                while (abstractFileName2 != null) {
                    ZipFileObject zipFileObject2 = (ZipFileObject)this.getFileFromCache(abstractFileName2);
                    if (zipFileObject2 == null) {
                        zipFileObject2 = this.createZipFileObject(abstractFileName2, null);
                        this.putFileToCache(zipFileObject2);
                        arrayList.add(zipFileObject2);
                        zipFileObject2.holdObject(arrayList);
                    }
                    zipFileObject2.attachChild(zipFileObject.getName());
                    zipFileObject = zipFileObject2;
                    abstractFileName2 = (AbstractFileName)abstractFileName2.getParent();
                }
            }
        }
        finally {
            this.closeCommunicationLink();
        }
    }

    protected ZipFile getZipFile() throws FileSystemException {
        if (this.zipFile == null && this.file.exists()) {
            ZipFile zipFile;
            this.zipFile = zipFile = this.createZipFile(this.file);
        }
        return this.zipFile;
    }

    protected ZipFileObject createZipFileObject(AbstractFileName abstractFileName, ZipEntry zipEntry) throws FileSystemException {
        return new ZipFileObject(abstractFileName, zipEntry, this, true);
    }

    protected ZipFile createZipFile(File file) throws FileSystemException {
        try {
            return new ZipFile(file);
        }
        catch (IOException iOException) {
            throw new FileSystemException("vfs.provider.zip/open-zip-file.error", file, (Throwable)iOException);
        }
    }

    @Override
    protected void doCloseCommunicationLink() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException iOException) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.zip/close-zip-file.error :" + this.file, iOException);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(ZipFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws FileSystemException {
        return new ZipFileObject(abstractFileName, null, this, false);
    }
}

