/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.zip.ZipFileSystem;
import org.eclipse.core.runtime.IProgressMonitor;

public class ZipFileObject
extends AbstractFileObject
implements FileObject {
    protected ZipEntry entry;
    private final HashSet<String> children = new HashSet();
    private final ZipFileSystem fs;
    private FileType type;

    protected ZipFileObject(AbstractFileName abstractFileName, ZipEntry zipEntry, ZipFileSystem zipFileSystem, boolean bl) throws FileSystemException {
        super(abstractFileName, zipFileSystem);
        this.fs = zipFileSystem;
        this.setZipEntry(zipEntry);
        if (!bl) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setZipEntry(ZipEntry zipEntry) {
        if (this.entry != null) {
            return;
        }
        this.type = zipEntry == null || zipEntry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = zipEntry;
    }

    public void attachChild(FileName fileName) {
        this.children.add(fileName.getBaseName());
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    @Override
    protected FileType doGetType() {
        return this.type;
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) {
        try {
            if (!this.getType().hasChildren()) {
                return null;
            }
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException);
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    @Override
    protected long doGetContentSize() {
        return this.entry.getSize();
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.entry.getTime();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
        }
        return this.fs.getZipFile().getInputStream(this.entry);
    }
}

