/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.http.HttpClientFactory;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;
import org.apache.commons.vfs2.provider.webdav.WebdavFileNameParser;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystem;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class WebdavFileProvider
extends HttpFileProvider {
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ, Capability.DIRECTORY_READ_CONTENT));

    public WebdavFileProvider() {
        this.setFileNameParser(WebdavFileNameParser.getInstance());
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient httpClient;
        GenericFileName genericFileName = (GenericFileName)fileName;
        FileSystemOptions fileSystemOptions2 = fileSystemOptions == null ? new FileSystemOptions() : fileSystemOptions;
        UserAuthenticationData userAuthenticationData = null;
        try {
            userAuthenticationData = UserAuthenticatorUtils.authenticate(fileSystemOptions2, AUTHENTICATOR_TYPES);
            String string = fileName.getScheme().equals("webdav") ? "http" : "https";
            httpClient = HttpClientFactory.createConnection(WebdavFileSystemConfigBuilder.getInstance(), string, genericFileName.getHostName(), genericFileName.getPort(), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(genericFileName.getUserName()))), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(genericFileName.getPassword()))), fileSystemOptions2);
        }
        finally {
            UserAuthenticatorUtils.cleanup(userAuthenticationData);
        }
        return new WebdavFileSystem(genericFileName, httpClient, fileSystemOptions2);
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return WebdavFileSystemConfigBuilder.getInstance();
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

