/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemPermissionException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.DefaultFileContent;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.commons.vfs2.provider.webdav.ExceptionConverter;
import org.apache.commons.vfs2.provider.webdav.WebdavFileContentInfoFactory;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystem;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav.WebdavMethodRetryHandler;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.CheckinMethod;
import org.apache.jackrabbit.webdav.client.methods.CheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PropPatchMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.client.methods.UncheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.VersionControlMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class WebdavFileObject
extends HttpFileObject
implements FileObject {
    private static final Logger LOG = LoggerFactory.getLogger(WebdavFileObject.class);
    public static final DavPropertyName RESPONSE_CHARSET = DavPropertyName.create("response-charset");
    private final WebdavFileSystem fileSystem;
    private final String urlCharset;
    private final WebdavFileSystemConfigBuilder builder;

    protected WebdavFileObject(AbstractFileName abstractFileName, WebdavFileSystem webdavFileSystem) {
        super(abstractFileName, webdavFileSystem);
        this.fileSystem = webdavFileSystem;
        this.builder = (WebdavFileSystemConfigBuilder)WebdavFileSystemConfigBuilder.getInstance();
        this.urlCharset = this.builder.getUrlCharset(this.getFileSystem().getFileSystemOptions());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create " + this);
        }
    }

    protected void configureMethod(HttpMethodBase httpMethodBase) {
        httpMethodBase.getParams().setParameter("http.method.retry-handler", (Object)WebdavMethodRetryHandler.getInstance());
    }

    @Override
    protected FileType doGetType() throws Exception {
        try {
            return this.isDirectory((URLFileName)this.getName()) ? FileType.FOLDER : FileType.FILE;
        }
        catch (FileNotFolderException fileNotFolderException) {
            return FileType.IMAGINARY;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return FileType.IMAGINARY;
        }
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) throws Exception {
        return null;
    }

    @Override
    protected FileObject[] doListChildrenResolved(IProgressMonitor iProgressMonitor) throws Exception {
        PropFindMethod propFindMethod = null;
        try {
            URLFileName uRLFileName = (URLFileName)this.getName();
            if (this.isDirectory(uRLFileName)) {
                DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
                davPropertyNameSet.add(DavPropertyName.create("displayname"));
                propFindMethod = new PropFindMethod(this.urlString(uRLFileName), davPropertyNameSet, 1);
                this.execute(propFindMethod);
                ArrayList<WebdavFileObject> arrayList = new ArrayList<WebdavFileObject>();
                if (propFindMethod.succeeded()) {
                    MultiStatusResponse[] multiStatusResponseArray = propFindMethod.getResponseBodyAsMultiStatus().getResponses();
                    int n = 0;
                    while (n < multiStatusResponseArray.length) {
                        String string;
                        MultiStatusResponse multiStatusResponse = multiStatusResponseArray[n];
                        if (!this.isCurrentFile(multiStatusResponse.getHref(), uRLFileName) && (string = this.resourceName(multiStatusResponse.getHref())) != null && string.length() > 0) {
                            FileSystem fileSystem = this.getFileSystem();
                            FileSystemManager fileSystemManager = fileSystem.getFileSystemManager();
                            FileName fileName = fileSystemManager.resolveName(this.getName(), string, NameScope.CHILD);
                            FileObject fileObject = fileSystem.resolveFile(fileName);
                            WebdavFileObject webdavFileObject = (WebdavFileObject)FileObjectUtils.getAbstractFileObject(fileObject);
                            arrayList.add(webdavFileObject);
                        }
                        ++n;
                    }
                }
                FileObject[] fileObjectArray = arrayList.toArray(new WebdavFileObject[arrayList.size()]);
                return fileObjectArray;
            }
            try {
                throw new FileNotFolderException(this.getName());
            }
            catch (FileNotFolderException fileNotFolderException) {
                throw fileNotFolderException;
            }
            catch (DavException davException) {
                throw new FileSystemException(davException.getMessage(), davException);
            }
            catch (IOException iOException) {
                throw new FileSystemException(iOException.getMessage(), iOException);
            }
        }
        finally {
            if (propFindMethod != null) {
                propFindMethod.releaseConnection();
            }
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        MkColMethod mkColMethod = new MkColMethod(this.urlString((URLFileName)this.getName()));
        this.setupMethod(mkColMethod);
        try {
            this.execute(mkColMethod);
        }
        catch (FileSystemException fileSystemException) {
            throw new FileSystemException("vfs.provider.webdav/create-collection.error", this.getName(), (Throwable)fileSystemException);
        }
    }

    @Override
    protected void doDelete(IProgressMonitor iProgressMonitor) throws Exception {
        DeleteMethod deleteMethod = new DeleteMethod(this.urlString((URLFileName)this.getName()));
        this.setupMethod(deleteMethod);
        this.execute(deleteMethod);
    }

    @Override
    protected void doRename(FileObject fileObject, IProgressMonitor iProgressMonitor) throws Exception {
        String string = this.encodePath(this.urlString((URLFileName)this.getName()));
        String string2 = this.urlString((URLFileName)fileObject.getName(), false);
        MoveMethod moveMethod = new MoveMethod(string, string2, false);
        this.setupMethod(moveMethod);
        this.execute(moveMethod);
    }

    @Override
    protected long doGetContentSize() throws Exception {
        DavProperty davProperty = this.getProperty((URLFileName)this.getName(), "getcontentlength");
        if (davProperty != null) {
            String string = (String)davProperty.getValue();
            return Long.parseLong(string);
        }
        return 0L;
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        DavProperty davProperty = this.getProperty((URLFileName)this.getName(), "getlastmodified");
        if (davProperty != null) {
            String string = (String)davProperty.getValue();
            return DateUtil.parseDate((String)string).getTime();
        }
        return 0L;
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            URLFileName uRLFileName = (URLFileName)this.getName();
            DavPropertySet davPropertySet = this.getProperties(uRLFileName, 1, new DavPropertyNameSet(), false);
            for (Object object : davPropertySet) {
                hashMap.put(object.getName().toString(), object.getValue());
            }
            davPropertySet = this.getPropertyNames(uRLFileName);
            for (DavProperty davProperty : davPropertySet) {
                if (hashMap.containsKey(davProperty.getName().getName()) || (davProperty = this.getProperty(uRLFileName, davProperty.getName())) == null) continue;
                DavPropertyName davPropertyName = davProperty.getName();
                Object t = davProperty.getValue();
                if (davPropertyName == null || t == null) continue;
                hashMap.put(((Object)davPropertyName).toString(), t);
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)exception);
        }
    }

    @Override
    protected void doSetAttribute(String string, Object object) throws Exception {
        try {
            URLFileName uRLFileName = (URLFileName)this.getName();
            String string2 = this.urlString(uRLFileName);
            DavPropertySet davPropertySet = new DavPropertySet();
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            DefaultDavProperty<Object> defaultDavProperty = new DefaultDavProperty<Object>(string, object, Namespace.EMPTY_NAMESPACE);
            if (object != null) {
                davPropertySet.add(defaultDavProperty);
            } else {
                davPropertyNameSet.add(defaultDavProperty.getName());
            }
            PropPatchMethod propPatchMethod = new PropPatchMethod(string2, davPropertySet, davPropertyNameSet);
            this.setupMethod(propPatchMethod);
            this.execute(propPatchMethod);
            if (!propPatchMethod.succeeded()) {
                throw new FileSystemException("Property '" + string + "' could not be set.");
            }
        }
        catch (FileSystemException fileSystemException) {
            throw fileSystemException;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)exception);
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        return new WebdavOutputStream(this);
    }

    @Override
    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new WebdavFileContentInfoFactory();
    }

    @Override
    protected void setupMethod(HttpMethod httpMethod) throws FileSystemException, URIException {
        String string = ((URLFileName)this.getName()).getPathQueryEncoded(this.urlCharset);
        httpMethod.setPath(string);
        httpMethod.setFollowRedirects(false);
        httpMethod.setRequestHeader("User-Agent", "Jakarta-Commons-VFS");
        httpMethod.addRequestHeader("Cache-control", "no-cache");
        httpMethod.addRequestHeader("Cache-store", "no-store");
        httpMethod.addRequestHeader("Pragma", "no-cache");
        httpMethod.addRequestHeader("Expires", "0");
    }

    private void execute(DavMethod davMethod) throws FileSystemException {
        try {
            try {
                int n = this.fileSystem.getClient().executeMethod((HttpMethod)davMethod);
                if (LOG.isInfoEnabled()) {
                    LOG.info(WebdavFileObject.toString(davMethod));
                }
                if (n == 404 || n == 410) {
                    throw new FileNotFoundException(davMethod.getURI());
                }
                if (n == 403) {
                    throw new FileSystemPermissionException("Forbidden " + WebdavFileObject.getUri(davMethod));
                }
                davMethod.checkSuccess();
            }
            catch (FileSystemException fileSystemException) {
                throw fileSystemException;
            }
            catch (IOException iOException) {
                throw new FileSystemException(iOException);
            }
            catch (DavException davException) {
                if (LOG.isInfoEnabled()) {
                    LOG.warn("Failed to execute " + davMethod, (Throwable)davException);
                }
                throw ExceptionConverter.generate(davException);
            }
        }
        finally {
            if (davMethod != null) {
                davMethod.releaseConnection();
            }
        }
    }

    private boolean isDirectory(URLFileName uRLFileName) throws IOException {
        try {
            Node node;
            DavProperty davProperty = this.getProperty(uRLFileName, "resourcetype");
            if (davProperty != null && (node = (Node)davProperty.getValue()) != null) {
                return node.getLocalName().equals("collection");
            }
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFolderException(uRLFileName);
        }
    }

    DavProperty getProperty(URLFileName uRLFileName, String string) throws FileSystemException {
        return this.getProperty(uRLFileName, DavPropertyName.create(string));
    }

    DavProperty getProperty(URLFileName uRLFileName, DavPropertyName davPropertyName) throws FileSystemException {
        DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
        davPropertyNameSet.add(davPropertyName);
        DavPropertySet davPropertySet = this.getProperties(uRLFileName, davPropertyNameSet, false);
        return davPropertySet.get(davPropertyName);
    }

    DavPropertySet getProperties(URLFileName uRLFileName, DavPropertyNameSet davPropertyNameSet, boolean bl) throws FileSystemException {
        return this.getProperties(uRLFileName, 0, davPropertyNameSet, bl);
    }

    DavPropertySet getProperties(URLFileName uRLFileName) throws FileSystemException {
        return this.getProperties(uRLFileName, 1, new DavPropertyNameSet(), false);
    }

    DavPropertySet getPropertyNames(URLFileName uRLFileName) throws FileSystemException {
        return this.getProperties(uRLFileName, 2, new DavPropertyNameSet(), false);
    }

    DavPropertySet getProperties(URLFileName uRLFileName, int n, DavPropertyNameSet davPropertyNameSet, boolean bl) throws FileSystemException {
        try {
            String string = this.urlString(uRLFileName);
            PropFindMethod propFindMethod = new PropFindMethod(string, n, davPropertyNameSet, 0);
            this.setupMethod(propFindMethod);
            this.execute(propFindMethod);
            if (propFindMethod.succeeded()) {
                MultiStatus multiStatus = propFindMethod.getResponseBodyAsMultiStatus();
                MultiStatusResponse multiStatusResponse = multiStatus.getResponses()[0];
                DavPropertySet davPropertySet = multiStatusResponse.getProperties(200);
                if (bl) {
                    DefaultDavProperty<String> defaultDavProperty = new DefaultDavProperty<String>(RESPONSE_CHARSET, propFindMethod.getResponseCharSet());
                    davPropertySet.add(defaultDavProperty);
                }
                return davPropertySet;
            }
            return new DavPropertySet();
        }
        catch (FileSystemException fileSystemException) {
            throw fileSystemException;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)exception);
        }
    }

    private String resourceName(String string) {
        int n;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return (n = string.lastIndexOf("/")) >= 0 ? string.substring(n + 1) : string;
    }

    private String urlString(URLFileName uRLFileName) {
        return this.urlString(uRLFileName, true);
    }

    private String urlString(URLFileName uRLFileName, boolean bl) {
        String string = null;
        String string2 = null;
        if (bl) {
            string = uRLFileName.getUserName();
            string2 = uRLFileName.getPassword();
        }
        String string3 = uRLFileName.getScheme().equals("webdav") ? "http" : "https";
        URLFileName uRLFileName2 = new URLFileName(string3, uRLFileName.getHostName(), uRLFileName.getPort(), uRLFileName.getDefaultPort(), string, string2, uRLFileName.getPath(), uRLFileName.getType(), uRLFileName.getQueryString());
        try {
            return uRLFileName2.getURIEncoded(this.urlCharset);
        }
        catch (Exception exception) {
            return uRLFileName.getURI();
        }
    }

    private boolean isCurrentFile(String string, URLFileName uRLFileName) {
        String string2 = this.hrefString(uRLFileName);
        if (string.endsWith("/") && !string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        return string.equals(string2) || string.equals(uRLFileName.getPath());
    }

    private String hrefString(URLFileName uRLFileName) {
        String string = uRLFileName.getScheme().equals("webdav") ? "http" : "https";
        URLFileName uRLFileName2 = new URLFileName(string, uRLFileName.getHostName(), uRLFileName.getPort(), uRLFileName.getDefaultPort(), null, null, uRLFileName.getPath(), uRLFileName.getType(), uRLFileName.getQueryString());
        try {
            return uRLFileName2.getURIEncoded(this.urlCharset);
        }
        catch (Exception exception) {
            return uRLFileName.getURI();
        }
    }

    private static final String getUri(DavMethod davMethod) {
        try {
            return davMethod.getURI().toString();
        }
        catch (URIException uRIException) {
            return "Unknown URI " + uRIException.getMessage();
        }
    }

    private static final String toString(DavMethod davMethod) {
        Header[] headerArray;
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Request: ").append(davMethod.getName());
        stringBuilder.append(" ").append(WebdavFileObject.getUri(davMethod));
        stringBuilder.append("\nResponse ");
        stringBuilder.append(davMethod.getStatusCode()).append(' ');
        stringBuilder.append(davMethod.getStatusText()).append('\n');
        Header[] headerArray2 = headerArray = davMethod.getResponseHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray2[n2];
            stringBuilder.append('\t').append(header);
            ++n2;
        }
        try {
            stringBuilder.append(davMethod.getResponseBodyAsString());
        }
        catch (IOException iOException) {
            stringBuilder.append("Cannot get body because of ").append(iOException.getMessage());
        }
        return stringBuilder.toString();
    }

    private class WebdavOutputStream
    extends MonitorOutputStream {
        private WebdavFileObject file;

        public WebdavOutputStream(WebdavFileObject webdavFileObject2) {
            super(new ByteArrayOutputStream());
            this.file = webdavFileObject2;
        }

        @Override
        protected void onClose() throws IOException {
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(((ByteArrayOutputStream)this.out).toByteArray());
            URLFileName uRLFileName = (URLFileName)WebdavFileObject.this.getName();
            String string = WebdavFileObject.this.urlString(uRLFileName);
            if (WebdavFileObject.this.builder.isVersioning(WebdavFileObject.this.getFileSystem().getFileSystemOptions())) {
                DavConstants davConstants;
                boolean bl;
                boolean bl2;
                block21: {
                    DavPropertySet davPropertySet = null;
                    bl2 = true;
                    bl = true;
                    try {
                        davPropertySet = WebdavFileObject.this.getPropertyNames(uRLFileName);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        bl2 = false;
                    }
                    if (bl2 && davPropertySet != null) {
                        if (davPropertySet.contains(VersionControlledResource.CHECKED_OUT)) {
                            bl = false;
                        } else if (!davPropertySet.contains(VersionControlledResource.CHECKED_IN) && (davConstants = davPropertySet.get(VersionControlledResource.AUTO_VERSION)) != null && "checkout-checkin".equals((davConstants = WebdavFileObject.this.getProperty(uRLFileName, VersionControlledResource.AUTO_VERSION)).getValue())) {
                            this.createVersion(string);
                        }
                    }
                    if (bl2 && bl) {
                        try {
                            davConstants = new CheckoutMethod(string);
                            WebdavFileObject.this.setupMethod((HttpMethod)davConstants);
                            WebdavFileObject.this.execute((DavMethod)((Object)davConstants));
                            bl = false;
                        }
                        catch (FileSystemException fileSystemException) {}
                    }
                    try {
                        davConstants = new PutMethod(string);
                        davConstants.setRequestEntity((RequestEntity)byteArrayRequestEntity);
                        WebdavFileObject.this.setupMethod((HttpMethod)davConstants);
                        WebdavFileObject.this.execute((DavMethod)((Object)davConstants));
                        this.setUserName(uRLFileName, string);
                    }
                    catch (FileSystemException fileSystemException) {
                        if (bl) break block21;
                        try {
                            UncheckoutMethod uncheckoutMethod = new UncheckoutMethod(string);
                            WebdavFileObject.this.setupMethod(uncheckoutMethod);
                            WebdavFileObject.this.execute(uncheckoutMethod);
                            bl = true;
                        }
                        catch (Exception exception) {}
                        throw fileSystemException;
                    }
                }
                if (!bl2) {
                    this.createVersion(string);
                    try {
                        davConstants = WebdavFileObject.this.getPropertyNames(uRLFileName);
                        bl = !((DavPropertySet)davConstants).contains(VersionControlledResource.CHECKED_OUT);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
                if (!bl) {
                    davConstants = new CheckinMethod(string);
                    WebdavFileObject.this.setupMethod((HttpMethod)davConstants);
                    WebdavFileObject.this.execute((DavMethod)((Object)davConstants));
                }
            } else {
                PutMethod putMethod = new PutMethod(string);
                putMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
                WebdavFileObject.this.setupMethod(putMethod);
                WebdavFileObject.this.execute(putMethod);
                try {
                    this.setUserName(uRLFileName, string);
                }
                catch (IOException iOException) {}
            }
            ((DefaultFileContent)this.file.getContent()).resetAttributes();
        }

        private void setUserName(URLFileName uRLFileName, String string) throws IOException {
            Object object;
            ArrayList<DefaultDavProperty<String>> arrayList = new ArrayList<DefaultDavProperty<String>>();
            String string2 = WebdavFileObject.this.builder.getCreatorName(WebdavFileObject.this.getFileSystem().getFileSystemOptions());
            String string3 = uRLFileName.getUserName();
            if (string2 == null) {
                string2 = string3;
            } else if (string3 != null) {
                object = "Modified by user " + string3;
                arrayList.add(new DefaultDavProperty<String>(DeltaVConstants.COMMENT, (String)object));
            }
            arrayList.add(new DefaultDavProperty<String>(DeltaVConstants.CREATOR_DISPLAYNAME, string2));
            object = new PropPatchMethod(string, arrayList);
            WebdavFileObject.this.setupMethod((HttpMethod)object);
            WebdavFileObject.this.execute((DavMethod)object);
        }

        private boolean createVersion(String string) {
            try {
                VersionControlMethod versionControlMethod = new VersionControlMethod(string);
                WebdavFileObject.this.setupMethod(versionControlMethod);
                WebdavFileObject.this.execute(versionControlMethod);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

