/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import java.lang.reflect.Constructor;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.w3c.dom.Element;

public final class ExceptionConverter {
    private ExceptionConverter() {
    }

    public static FileSystemException generate(DavException davException) throws FileSystemException {
        return ExceptionConverter.generate(davException, null);
    }

    public static FileSystemException generate(DavException davException, DavMethod davMethod) throws FileSystemException {
        String string = davException.getMessage();
        if (davException.hasErrorCondition()) {
            try {
                Element element = davException.toXml(DomUtil.createDocument());
                if (DomUtil.matches(element, "error", DavConstants.NAMESPACE) && DomUtil.hasChildElement(element, "exception", null)) {
                    Class<?> clazz;
                    Constructor<?> constructor;
                    Element element2 = DomUtil.getChildElement(element, "exception", null);
                    if (DomUtil.hasChildElement(element2, "message", null)) {
                        string = DomUtil.getChildText(element2, "message", null);
                    }
                    if (DomUtil.hasChildElement(element2, "class", null) && (constructor = (clazz = Class.forName(DomUtil.getChildText(element2, "class", null))).getConstructor(String.class)) != null) {
                        Object obj = constructor.newInstance(string);
                        if (obj instanceof FileSystemException) {
                            return (FileSystemException)obj;
                        }
                        if (obj instanceof Exception) {
                            return new FileSystemException(string, (Exception)obj);
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new FileSystemException(exception);
            }
        }
        return new FileSystemException(string);
    }
}

