/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.url.UrlFileNameParser;
import org.apache.commons.vfs2.provider.url.UrlFileSystem;

public class UrlFileProvider
extends AbstractFileProvider {
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED));

    public UrlFileProvider() {
        this.setFileNameParser(new UrlFileNameParser());
    }

    @Override
    public synchronized FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(uRL, "/");
            String string2 = String.valueOf(this.getClass().getName()) + uRL2.toString();
            FileSystem fileSystem = this.findFileSystem((Comparable<?>)((Object)string2), fileSystemOptions);
            if (fileSystem == null) {
                String string3 = uRL2.toExternalForm();
                FileName fileName = this.getContext().parseURI(string3);
                fileSystem = new UrlFileSystem(fileName, fileSystemOptions);
                this.addFileSystem((Comparable<?>)((Object)string2), fileSystem);
            }
            return fileSystem.resolveFile(uRL.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", string, (Throwable)malformedURLException);
        }
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

