/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.url.UrlFileSystem;
import org.eclipse.core.runtime.IProgressMonitor;

public class UrlFileObject
extends AbstractFileObject
implements FileObject {
    private URL url;

    protected UrlFileObject(UrlFileSystem urlFileSystem, AbstractFileName abstractFileName) {
        super(abstractFileName, urlFileSystem);
    }

    @Override
    protected void doAttach() throws Exception {
        if (this.url == null) {
            this.url = this.createURL(this.getName());
        }
    }

    protected URL createURL(FileName fileName) throws MalformedURLException, FileSystemException, URIException {
        if (fileName instanceof URLFileName) {
            URLFileName uRLFileName = (URLFileName)this.getName();
            return new URL(uRLFileName.getURIEncoded(null));
        }
        return new URL(this.getName().getURI());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected FileType doGetType() throws Exception {
        try {
            URLConnection uRLConnection = this.url.openConnection();
            try (InputStream inputStream = uRLConnection.getInputStream();){
                int n;
                if (uRLConnection instanceof HttpURLConnection && 200 != (n = ((HttpURLConnection)uRLConnection).getResponseCode())) {
                    FileType fileType = FileType.IMAGINARY;
                    return fileType;
                }
                FileType fileType = FileType.FILE;
                return fileType;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return FileType.IMAGINARY;
        }
    }

    @Override
    protected long doGetContentSize() throws Exception {
        URLConnection uRLConnection = this.url.openConnection();
        try (InputStream inputStream = uRLConnection.getInputStream();){
            long l = uRLConnection.getContentLength();
            return l;
        }
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        URLConnection uRLConnection = this.url.openConnection();
        try (InputStream inputStream = uRLConnection.getInputStream();){
            long l = uRLConnection.getLastModified();
            return l;
        }
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) throws Exception {
        throw new FileSystemException("Not implemented.");
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        return this.url.openStream();
    }
}

