/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.URLFileNameParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.provider.local.GenericFileNameParser;

public class UrlFileNameParser
extends AbstractFileNameParser {
    private final URLFileNameParser url = new URLFileNameParser(80);
    private final GenericFileNameParser generic = new GenericFileNameParser();

    @Override
    public boolean encodeCharacter(char c) {
        return super.encodeCharacter(c) || c == '?';
    }

    @Override
    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        if (this.isUrlBased(fileName, string)) {
            return this.url.parseUri(vfsComponentContext, fileName, string);
        }
        return this.generic.parseUri(vfsComponentContext, fileName, string);
    }

    protected boolean isUrlBased(FileName fileName, String string) {
        if (fileName instanceof URLFileName) {
            return true;
        }
        int n = this.countSlashes(string);
        return n == 2;
    }

    protected int countSlashes(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (n == 0) {
                if ((c < 'a' || c > 'z') && c == ':') {
                    ++n;
                }
            } else if (n == 1) {
                if (c == '/') {
                    ++n2;
                } else {
                    return n2;
                }
            }
            ++n3;
        }
        return n2;
    }
}

