/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.temp;

import java.io.File;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;

public class TemporaryFileProvider
extends AbstractFileProvider
implements FileProvider,
Comparable<Object> {
    private File rootFile;

    public TemporaryFileProvider(File file) {
        this();
        this.rootFile = file;
    }

    public TemporaryFileProvider() {
    }

    @Override
    public int compareTo(Object object) {
        int n;
        int n2 = this.hashCode();
        if (n2 < (n = object.hashCode())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    @Override
    public synchronized FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = UriParser.extractScheme(string, stringBuilder);
        UriParser.fixSeparators(stringBuilder);
        UriParser.normalisePath(stringBuilder);
        String string3 = stringBuilder.toString();
        FileSystem fileSystem = this.findFileSystem(this, fileSystemOptions);
        if (fileSystem == null) {
            if (this.rootFile == null) {
                this.rootFile = this.getContext().getTemporaryFileStore().allocateFile("tempfs");
            }
            FileName fileName = this.getContext().parseURI(String.valueOf(string2) + ":" + "/");
            fileSystem = new LocalFileSystem(fileName, this.rootFile.getAbsolutePath(), fileSystemOptions);
            this.addFileSystem(this, fileSystem);
        }
        return fileSystem.resolveFile(string3);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return DefaultLocalFileProvider.capabilities;
    }
}

