/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.provider.tar.TarBuffer;
import org.apache.commons.vfs2.provider.tar.TarEntry;

class TarInputStream
extends FilterInputStream {
    private TarBuffer buffer;
    private TarEntry currEntry;
    private boolean debug;
    private int entryOffset;
    private long entrySize;
    private boolean hasHitEOF;
    private byte[] oneBuf;
    private byte[] readBuf;

    TarInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    TarInputStream(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    TarInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream);
        this.buffer = new TarBuffer(inputStream, n, n2);
        this.oneBuf = new byte[1];
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        this.buffer.setDebug(bl);
    }

    public TarEntry getNextEntry() throws IOException {
        CharSequence charSequence;
        byte[] byArray;
        Object object;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long l = this.entrySize - (long)this.entryOffset;
            if (this.debug) {
                object = "TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + l + " bytes";
                this.debug((String)object);
            }
            if (l > 0L) {
                this.longSkip(l);
            }
            this.readBuf = null;
        }
        if ((byArray = this.buffer.readRecord()) == null) {
            if (this.debug) {
                this.debug("READ NULL RECORD");
            }
            this.hasHitEOF = true;
            this.currEntry = null;
        } else if (this.buffer.isEOFRecord(byArray)) {
            if (this.debug) {
                this.debug("READ EOF RECORD");
            }
            this.hasHitEOF = true;
            this.currEntry = null;
        } else {
            this.currEntry = new TarEntry(byArray);
            if (byArray[257] == 117 && byArray[258] == 115 && byArray[259] == 116 && byArray[260] == 97) {
                byte cfr_ignored_0 = byArray[261];
            }
            if (this.debug) {
                charSequence = "TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize();
                this.debug((String)charSequence);
            }
            this.entryOffset = 0;
            this.entrySize = this.currEntry.getSize();
        }
        if (this.currEntry != null && this.currEntry.isGNULongNameEntry()) {
            charSequence = new StringBuffer();
            object = new byte[256];
            int n = 0;
            while ((n = this.read((byte[])object)) >= 0) {
                String string = new String((byte[])object, 0, n);
                ((StringBuffer)charSequence).append(string);
            }
            this.getNextEntry();
            if (((StringBuffer)charSequence).length() > 0 && ((StringBuffer)charSequence).charAt(((StringBuffer)charSequence).length() - 1) == '\u0000') {
                ((StringBuffer)charSequence).deleteCharAt(((StringBuffer)charSequence).length() - 1);
            }
            this.currEntry.setName(((StringBuffer)charSequence).toString());
        }
        return this.currEntry;
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    @Override
    public int available() throws IOException {
        long l = this.entrySize - (long)this.entryOffset;
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public void copyEntryContents(OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = this.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.oneBuf, 0, 1);
        if (n == -1) {
            return n;
        }
        return this.oneBuf[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        if ((long)this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)(n5 + this.entryOffset) > this.entrySize) {
            n5 = (int)(this.entrySize - (long)this.entryOffset);
        }
        if (this.readBuf != null) {
            int n7 = n5 > this.readBuf.length ? this.readBuf.length : n5;
            System.arraycopy(this.readBuf, 0, byArray, n4, n7);
            if (n7 >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                n3 = this.readBuf.length - n7;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.readBuf, n7, byArray2, 0, n3);
                this.readBuf = byArray2;
            }
            n6 += n7;
            n5 -= n7;
            n4 += n7;
        }
        while (n5 > 0) {
            byte[] byArray3 = this.buffer.readRecord();
            if (byArray3 == null) {
                String string = "unexpected EOF with " + n5 + " bytes unread";
                throw new IOException(string);
            }
            int n8 = byArray3.length;
            n3 = n5;
            if (n8 > n3) {
                System.arraycopy(byArray3, 0, byArray, n4, n3);
                this.readBuf = new byte[n8 - n3];
                System.arraycopy(byArray3, n3, this.readBuf, 0, n8 - n3);
            } else {
                n3 = n8;
                System.arraycopy(byArray3, 0, byArray, n4, n8);
            }
            n6 += n3;
            n5 -= n3;
            n4 += n3;
        }
        this.entryOffset += n6;
        return n6;
    }

    @Override
    public void reset() {
    }

    public void longSkip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            if (l - l2 > Integer.MAX_VALUE) {
                this.skip(Integer.MAX_VALUE);
                l2 += Integer.MAX_VALUE;
                continue;
            }
            this.skip((int)(l - l2));
            l2 += l - l2;
        }
    }

    public void skip(int n) throws IOException {
        byte[] byArray = new byte[8192];
        int n2 = n;
        while (n2 > 0) {
            int n3 = n2 > byArray.length ? byArray.length : n2;
            int n4 = this.read(byArray, 0, n3);
            if (n4 == -1) break;
            n2 -= n4;
        }
    }

    protected void debug(String string) {
        if (this.debug) {
            System.err.println(string);
        }
    }
}

