/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileObject;
import org.apache.commons.vfs2.provider.tar.TarEntry;
import org.apache.commons.vfs2.provider.tar.TarFileObject;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.provider.tar.TarInputStream;

public class TarFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(TarFileSystem.class);
    private final File file;
    private TarInputStream tarFile;

    protected TarFileSystem(AbstractFileName abstractFileName, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(abstractFileName, fileObject, fileSystemOptions);
        this.file = fileObject.getFileSystem().replicateFile(fileObject, Selectors.SELECT_SELF, null);
        if (!this.file.exists()) {
            this.tarFile = null;
            return;
        }
    }

    @Override
    public void init() throws FileSystemException {
        super.init();
        try {
            try {
                TarEntry tarEntry;
                ArrayList<TarFileObject> arrayList = new ArrayList<TarFileObject>(100);
                while ((tarEntry = this.getTarFile().getNextEntry()) != null) {
                    TarFileObject tarFileObject;
                    AbstractFileName abstractFileName = (AbstractFileName)this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(tarEntry.getName()));
                    if (tarEntry.isDirectory() && this.getFileFromCache(abstractFileName) != null) {
                        tarFileObject = (TarFileObject)this.getFileFromCache(abstractFileName);
                        tarFileObject.setTarEntry(tarEntry);
                        continue;
                    }
                    tarFileObject = this.createTarFileObject(abstractFileName, tarEntry);
                    this.putFileToCache(tarFileObject);
                    arrayList.add(tarFileObject);
                    tarFileObject.holdObject(arrayList);
                    TarFileObject tarFileObject2 = null;
                    AbstractFileName abstractFileName2 = (AbstractFileName)abstractFileName.getParent();
                    while (abstractFileName2 != null) {
                        tarFileObject2 = (TarFileObject)this.getFileFromCache(abstractFileName2);
                        if (tarFileObject2 == null) {
                            tarFileObject2 = this.createTarFileObject(abstractFileName2, null);
                            this.putFileToCache(tarFileObject2);
                            arrayList.add(tarFileObject2);
                            tarFileObject2.holdObject(arrayList);
                        }
                        tarFileObject2.attachChild(tarFileObject.getName());
                        tarFileObject = tarFileObject2;
                        abstractFileName2 = (AbstractFileName)abstractFileName2.getParent();
                    }
                }
            }
            catch (IOException iOException) {
                throw new FileSystemException(iOException);
            }
        }
        finally {
            this.closeCommunicationLink();
        }
    }

    public InputStream getInputStream(TarEntry tarEntry) throws FileSystemException {
        this.resetTarFile();
        try {
            while (!this.tarFile.getNextEntry().equals(tarEntry)) {
            }
            return this.tarFile;
        }
        catch (IOException iOException) {
            throw new FileSystemException(iOException);
        }
    }

    protected void resetTarFile() throws FileSystemException {
        if (this.file.exists()) {
            this.recreateTarFile();
        }
    }

    private void recreateTarFile() throws FileSystemException {
        TarInputStream tarInputStream;
        if (this.tarFile != null) {
            try {
                this.tarFile.close();
            }
            catch (IOException iOException) {
                throw new FileSystemException("vfs.provider.tar/close-tar-file.error", this.file, (Throwable)iOException);
            }
            this.tarFile = null;
        }
        this.tarFile = tarInputStream = this.createTarFile(this.file);
    }

    protected TarInputStream getTarFile() throws FileSystemException {
        if (this.tarFile == null && this.file.exists()) {
            this.recreateTarFile();
        }
        return this.tarFile;
    }

    protected TarFileObject createTarFileObject(AbstractFileName abstractFileName, TarEntry tarEntry) throws FileSystemException {
        return new TarFileObject(abstractFileName, tarEntry, this, true);
    }

    protected TarInputStream createTarFile(File file) throws FileSystemException {
        try {
            if ("tgz".equalsIgnoreCase(this.getRootName().getScheme())) {
                return new TarInputStream(new GZIPInputStream(new FileInputStream(file)));
            }
            if ("tbz2".equalsIgnoreCase(this.getRootName().getScheme())) {
                return new TarInputStream(Bzip2FileObject.wrapInputStream(file.getAbsolutePath(), new FileInputStream(file)));
            }
            return new TarInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new FileSystemException("vfs.provider.tar/open-tar-file.error", file, (Throwable)iOException);
        }
    }

    @Override
    protected void doCloseCommunicationLink() {
        try {
            if (this.tarFile != null) {
                this.tarFile.close();
                this.tarFile = null;
            }
        }
        catch (IOException iOException) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.tar/close-tar-file.error :" + this.file, iOException);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(TarFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws FileSystemException {
        return new TarFileObject(abstractFileName, null, this, false);
    }
}

