/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.tar.TarEntry;
import org.apache.commons.vfs2.provider.tar.TarFileSystem;
import org.eclipse.core.runtime.IProgressMonitor;

public class TarFileObject
extends AbstractFileObject
implements FileObject {
    protected TarEntry entry;
    private final HashSet<String> children = new HashSet();
    private final TarFileSystem fs;
    private FileType type;

    protected TarFileObject(AbstractFileName abstractFileName, TarEntry tarEntry, TarFileSystem tarFileSystem, boolean bl) throws FileSystemException {
        super(abstractFileName, tarFileSystem);
        this.fs = tarFileSystem;
        this.setTarEntry(tarEntry);
        if (!bl) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setTarEntry(TarEntry tarEntry) {
        if (this.entry != null) {
            return;
        }
        this.type = tarEntry == null || tarEntry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = tarEntry;
    }

    protected void attachChild(FileName fileName) {
        this.children.add(fileName.getBaseName());
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    @Override
    protected FileType doGetType() {
        return this.type;
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) {
        try {
            if (!this.getType().hasChildren()) {
                return null;
            }
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException);
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    @Override
    protected long doGetContentSize() {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getSize();
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getModTime().getTime();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
        }
        return this.fs.getInputStream(this.entry);
    }
}

