/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.vfs2.provider.tar.TarUtils;

class TarEntry {
    public static final int NAMELEN = 100;
    private int checkSum;
    private int devMajor;
    private int devMinor;
    private File file;
    private int groupID;
    private StringBuffer groupName;
    private byte linkFlag;
    private StringBuffer linkName;
    private StringBuffer magic = new StringBuffer("ustar");
    private long modTime;
    private int mode;
    private StringBuffer name = new StringBuffer();
    private long size;
    private int userID;
    private StringBuffer userName;

    TarEntry(String string) {
        this();
        boolean bl = string.endsWith("/");
        this.name = new StringBuffer(string);
        this.mode = bl ? 16877 : 33188;
        this.linkFlag = (byte)(bl ? 53 : 48);
        this.modTime = new Date().getTime() / 1000L;
        this.linkName = new StringBuffer("");
        this.userName = new StringBuffer("");
        this.groupName = new StringBuffer("");
    }

    TarEntry(String string, byte by) {
        this(string);
        this.linkFlag = by;
    }

    TarEntry(File file) {
        this();
        int n;
        this.file = file;
        String string = file.getPath();
        String string2 = System.getProperty("os.name").toLowerCase(Locale.US);
        if (-1 != string2.indexOf("netware")) {
            if (string.length() > 2) {
                n = string.charAt(0);
                char c = string.charAt(1);
                if (c == ':' && (n >= 97 && n <= 122 || n >= 65 && n <= 90)) {
                    string = string.substring(2);
                }
            }
        } else if (-1 != string2.indexOf("netware") && (n = string.indexOf(58)) != -1) {
            string = string.substring(n + 1);
        }
        string = string.replace(File.separatorChar, '/');
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.linkName = new StringBuffer("");
        this.name = new StringBuffer(string);
        if (file.isDirectory()) {
            this.mode = 16877;
            this.linkFlag = (byte)53;
            if (this.name.charAt(this.name.length() - 1) != '/') {
                this.name.append("/");
            }
        } else {
            this.mode = 33188;
            this.linkFlag = (byte)48;
        }
        this.size = file.length();
        this.modTime = file.lastModified() / 1000L;
        this.checkSum = 0;
        this.devMajor = 0;
        this.devMinor = 0;
    }

    TarEntry(byte[] byArray) {
        this();
        this.parseTarHeader(byArray);
    }

    private TarEntry() {
        this.linkName = new StringBuffer();
        String string = System.getProperty("user.name", "");
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.userName = new StringBuffer(string);
        this.groupName = new StringBuffer("");
    }

    public void setGroupID(int n) {
        this.groupID = n;
    }

    public void setGroupName(String string) {
        this.groupName = new StringBuffer(string);
    }

    public void setModTime(long l) {
        this.modTime = l / 1000L;
    }

    public void setModTime(Date date) {
        this.modTime = date.getTime() / 1000L;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setName(String string) {
        this.name = new StringBuffer(string);
    }

    public void setSize(long l) {
        this.size = l;
    }

    public void setUserID(int n) {
        this.userID = n;
    }

    public void setUserName(String string) {
        this.userName = new StringBuffer(string);
    }

    public TarEntry[] getDirectoryEntries() {
        if (this.file == null || !this.file.isDirectory()) {
            return new TarEntry[0];
        }
        String[] stringArray = this.file.list();
        TarEntry[] tarEntryArray = new TarEntry[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            tarEntryArray[n] = new TarEntry(new File(this.file, stringArray[n]));
            ++n;
        }
        return tarEntryArray;
    }

    public File getFile() {
        return this.file;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public String getGroupName() {
        return this.groupName.toString();
    }

    public Date getModTime() {
        return new Date(this.modTime * 1000L);
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name.toString();
    }

    public long getSize() {
        return this.size;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public int getUserID() {
        return this.userID;
    }

    public String getUserName() {
        return this.userName.toString();
    }

    public boolean isDescendent(TarEntry tarEntry) {
        return tarEntry.getName().startsWith(this.getName());
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.linkFlag == 53) {
            return true;
        }
        return this.getName().endsWith("/");
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76 && this.name.toString().equals("././@LongLink");
    }

    public boolean equals(Object object) {
        if (!(object instanceof TarEntry)) {
            return false;
        }
        TarEntry tarEntry = (TarEntry)object;
        return this.getName().equals(tarEntry.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private void parseTarHeader(byte[] byArray) {
        int n = 0;
        this.name = TarUtils.parseName(byArray, n, 100);
        this.mode = (int)TarUtils.parseOctal(byArray, n += 100, 8);
        this.userID = (int)TarUtils.parseOctal(byArray, n += 8, 8);
        this.groupID = (int)TarUtils.parseOctal(byArray, n += 8, 8);
        this.size = TarUtils.parseOctal(byArray, n += 8, 12);
        this.modTime = TarUtils.parseOctal(byArray, n += 12, 12);
        this.checkSum = (int)TarUtils.parseOctal(byArray, n += 12, 8);
        n += 8;
        this.linkFlag = byArray[n++];
        this.linkName = TarUtils.parseName(byArray, n, 100);
        this.magic = TarUtils.parseName(byArray, n += 100, 8);
        this.userName = TarUtils.parseName(byArray, n += 8, 32);
        this.groupName = TarUtils.parseName(byArray, n += 32, 32);
        this.devMajor = (int)TarUtils.parseOctal(byArray, n += 32, 8);
        this.devMinor = (int)TarUtils.parseOctal(byArray, n += 8, 8);
    }

    public void writeEntryHeader(byte[] byArray) {
        int n = 0;
        n = TarUtils.getNameBytes(this.name, byArray, n, 100);
        n = TarUtils.getOctalBytes(this.mode, byArray, n, 8);
        n = TarUtils.getOctalBytes(this.userID, byArray, n, 8);
        n = TarUtils.getOctalBytes(this.groupID, byArray, n, 8);
        n = TarUtils.getLongOctalBytes(this.size, byArray, n, 12);
        int n2 = n = TarUtils.getLongOctalBytes(this.modTime, byArray, n, 12);
        int n3 = 0;
        while (n3 < 8) {
            byArray[n++] = 32;
            ++n3;
        }
        byArray[n++] = this.linkFlag;
        n = TarUtils.getNameBytes(this.linkName, byArray, n, 100);
        n = TarUtils.getNameBytes(this.magic, byArray, n, 8);
        n = TarUtils.getNameBytes(this.userName, byArray, n, 32);
        n = TarUtils.getNameBytes(this.groupName, byArray, n, 32);
        n = TarUtils.getOctalBytes(this.devMajor, byArray, n, 8);
        n = TarUtils.getOctalBytes(this.devMinor, byArray, n, 8);
        while (n < byArray.length) {
            byArray[n++] = 0;
        }
        long l = TarUtils.computeCheckSum(byArray);
        TarUtils.getCheckSumOctalBytes(l, byArray, n2, 8);
    }
}

