/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

class TarBuffer {
    public static final int DEFAULT_RECORDSIZE = 512;
    public static final int DEFAULT_BLOCKSIZE = 10240;
    private byte[] blockBuffer;
    private int blockSize;
    private int currBlkIdx;
    private int currRecIdx;
    private boolean debug;
    private InputStream input;
    private OutputStream output;
    private int recordSize;
    private int recsPerBlock;

    TarBuffer(InputStream inputStream) {
        this(inputStream, 10240);
    }

    TarBuffer(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    TarBuffer(InputStream inputStream, int n, int n2) {
        this.input = inputStream;
        this.initialize(n, n2);
    }

    TarBuffer(OutputStream outputStream) {
        this(outputStream, 10240);
    }

    TarBuffer(OutputStream outputStream, int n) {
        this(outputStream, n, 512);
    }

    TarBuffer(OutputStream outputStream, int n, int n2) {
        this.output = outputStream;
        this.initialize(n, n2);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getCurrentBlockNum() {
        return this.currBlkIdx;
    }

    public int getCurrentRecordNum() {
        return this.currRecIdx - 1;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public boolean isEOFRecord(byte[] byArray) {
        int n = this.getRecordSize();
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void close() throws IOException {
        if (this.debug) {
            this.debug("TarBuffer.closeBuffer().");
        }
        if (this.output != null) {
            this.flushBlock();
            if (this.output != System.out && this.output != System.err) {
                this.output.close();
                this.output = null;
            }
        } else if (this.input != null && this.input != System.in) {
            this.input.close();
            this.input = null;
        }
    }

    public byte[] readRecord() throws IOException {
        Object object;
        if (this.debug) {
            object = "ReadRecord: recIdx = " + this.currRecIdx + " blkIdx = " + this.currBlkIdx;
            this.debug((String)object);
        }
        if (this.input == null) {
            throw new IOException("reading from an output buffer");
        }
        if (this.currRecIdx >= this.recsPerBlock && !this.readBlock()) {
            return null;
        }
        object = new byte[this.recordSize];
        System.arraycopy(this.blockBuffer, this.currRecIdx * this.recordSize, object, 0, this.recordSize);
        ++this.currRecIdx;
        return object;
    }

    public void skipRecord() throws IOException {
        if (this.debug) {
            String string = "SkipRecord: recIdx = " + this.currRecIdx + " blkIdx = " + this.currBlkIdx;
            this.debug(string);
        }
        if (this.input == null) {
            throw new IOException("reading (via skip) from an output buffer");
        }
        if (this.currRecIdx >= this.recsPerBlock && !this.readBlock()) {
            return;
        }
        ++this.currRecIdx;
    }

    public void writeRecord(byte[] byArray) throws IOException {
        String string;
        if (this.debug) {
            string = "WriteRecord: recIdx = " + this.currRecIdx + " blkIdx = " + this.currBlkIdx;
            this.debug(string);
        }
        if (this.output == null) {
            throw new IOException("writing to an input buffer");
        }
        if (byArray.length != this.recordSize) {
            string = "record to write has length '" + byArray.length + "' which is not the record size of '" + this.recordSize + "'";
            throw new IOException(string);
        }
        if (this.currRecIdx >= this.recsPerBlock) {
            this.writeBlock();
        }
        System.arraycopy(byArray, 0, this.blockBuffer, this.currRecIdx * this.recordSize, this.recordSize);
        ++this.currRecIdx;
    }

    public void writeRecord(byte[] byArray, int n) throws IOException {
        String string;
        if (this.debug) {
            string = "WriteRecord: recIdx = " + this.currRecIdx + " blkIdx = " + this.currBlkIdx;
            this.debug(string);
        }
        if (this.output == null) {
            throw new IOException("writing to an input buffer");
        }
        if (n + this.recordSize > byArray.length) {
            string = "record has length '" + byArray.length + "' with offset '" + n + "' which is less than the record size of '" + this.recordSize + "'";
            throw new IOException(string);
        }
        if (this.currRecIdx >= this.recsPerBlock) {
            this.writeBlock();
        }
        System.arraycopy(byArray, n, this.blockBuffer, this.currRecIdx * this.recordSize, this.recordSize);
        ++this.currRecIdx;
    }

    private void flushBlock() throws IOException {
        if (this.debug) {
            this.debug("TarBuffer.flushBlock() called.");
        }
        if (this.output == null) {
            throw new IOException("writing to an input buffer");
        }
        if (this.currRecIdx > 0) {
            this.writeBlock();
        }
    }

    private void initialize(int n, int n2) {
        this.debug = false;
        this.blockSize = n;
        this.recordSize = n2;
        this.recsPerBlock = this.blockSize / this.recordSize;
        this.blockBuffer = new byte[this.blockSize];
        if (this.input != null) {
            this.currBlkIdx = -1;
            this.currRecIdx = this.recsPerBlock;
        } else {
            this.currBlkIdx = 0;
            this.currRecIdx = 0;
        }
    }

    private boolean readBlock() throws IOException {
        if (this.debug) {
            String string = "ReadBlock: blkIdx = " + this.currBlkIdx;
            this.debug(string);
        }
        if (this.input == null) {
            throw new IOException("reading from an output buffer");
        }
        this.currRecIdx = 0;
        int n = 0;
        int n2 = this.blockSize;
        while (n2 > 0) {
            long l = this.input.read(this.blockBuffer, n, n2);
            if (l == -1L) {
                Arrays.fill(this.blockBuffer, n, n + n2, (byte)0);
                break;
            }
            n = (int)((long)n + l);
            n2 = (int)((long)n2 - l);
            if (l == (long)this.blockSize || !this.debug) continue;
            System.err.println("ReadBlock: INCOMPLETE READ " + l + " of " + this.blockSize + " bytes read.");
        }
        ++this.currBlkIdx;
        return true;
    }

    private void writeBlock() throws IOException {
        if (this.debug) {
            String string = "WriteBlock: blkIdx = " + this.currBlkIdx;
            this.debug(string);
        }
        if (this.output == null) {
            throw new IOException("writing to an input buffer");
        }
        this.output.write(this.blockBuffer, 0, this.blockSize);
        this.output.flush();
        this.currRecIdx = 0;
        ++this.currBlkIdx;
    }

    protected void debug(String string) {
        if (this.debug) {
            System.err.println(string);
        }
    }
}

