/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;

public final class SftpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    public static final ProxyType PROXY_HTTP = new ProxyType("http");
    public static final ProxyType PROXY_SOCKS5 = new ProxyType("socks");
    private static final SftpFileSystemConfigBuilder BUILDER = new SftpFileSystemConfigBuilder();
    private static final String USER_DIR_IS_ROOT = String.valueOf(SftpFileSystemConfigBuilder.class.getName()) + ".USER_DIR_IS_ROOT";
    private static final String TIMEOUT = String.valueOf(SftpFileSystemConfigBuilder.class.getName()) + ".TIMEOUT";

    private SftpFileSystemConfigBuilder() {
        super("sftp.");
    }

    public static SftpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setUserInfo(FileSystemOptions fileSystemOptions, UserInfo userInfo) {
        this.setParam(fileSystemOptions, UserInfo.class.getName(), userInfo);
    }

    public UserInfo getUserInfo(FileSystemOptions fileSystemOptions) {
        return (UserInfo)this.getParam(fileSystemOptions, UserInfo.class.getName());
    }

    public void setKnownHosts(FileSystemOptions fileSystemOptions, File file) throws FileSystemException {
        this.setParam(fileSystemOptions, "knownHosts", file);
    }

    public File getKnownHosts(FileSystemOptions fileSystemOptions) {
        return (File)this.getParam(fileSystemOptions, "knownHosts");
    }

    public void setIdentities(FileSystemOptions fileSystemOptions, Set<IdentityInfo> set) throws FileSystemException {
        this.setParam(fileSystemOptions, "identities", new HashSet<IdentityInfo>(set));
    }

    public void setCompression(FileSystemOptions fileSystemOptions, String string) throws FileSystemException {
        this.setParam(fileSystemOptions, "compression", string);
    }

    public String getCompression(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "compression");
    }

    public Set<IdentityInfo> getIdentities(FileSystemOptions fileSystemOptions) {
        return (Set)this.getParam(fileSystemOptions, "identities");
    }

    public void setStrictHostKeyChecking(FileSystemOptions fileSystemOptions, String string) throws FileSystemException {
        if (string == null || !string.equals("ask") && !string.equals("no") && !string.equals("yes")) {
            throw new FileSystemException("vfs.provider.sftp/StrictHostKeyChecking-arg.error", string);
        }
        this.setParam(fileSystemOptions, "StrictHostKeyChecking", string);
    }

    public String getStrictHostKeyChecking(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "StrictHostKeyChecking", "no");
    }

    public void setUserDirIsRoot(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, USER_DIR_IS_ROOT, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions fileSystemOptions) {
        return this.getBoolean(fileSystemOptions, USER_DIR_IS_ROOT, Boolean.TRUE);
    }

    public void setTimeout(FileSystemOptions fileSystemOptions, Integer n) {
        this.setParam(fileSystemOptions, TIMEOUT, n);
    }

    public Integer getTimeout(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, TIMEOUT);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return SftpFileSystem.class;
    }

    public void setProxyHost(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "proxyHost", string);
    }

    public void setProxyPort(FileSystemOptions fileSystemOptions, int n) {
        this.setParam(fileSystemOptions, "proxyPort", new Integer(n));
    }

    public String getProxyHost(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, "proxyPort", 0);
    }

    public void setProxyType(FileSystemOptions fileSystemOptions, ProxyType proxyType) {
        this.setParam(fileSystemOptions, "proxyType", proxyType);
    }

    public ProxyType getProxyType(FileSystemOptions fileSystemOptions) {
        return (ProxyType)this.getParam(fileSystemOptions, "proxyType");
    }

    public void setPreferredAuthentications(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "PreferredAuthentications", string);
    }

    public String getPreferredAuthentications(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, "PreferredAuthentications");
    }

    public static final class ProxyType
    implements Serializable,
    Comparable<ProxyType> {
        private static final long serialVersionUID = 20101208L;
        private final String proxyType;

        private ProxyType(String string) {
            this.proxyType = string;
        }

        @Override
        public int compareTo(ProxyType proxyType) {
            return this.proxyType.compareTo(proxyType.proxyType);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ProxyType proxyType = (ProxyType)object;
            return !(this.proxyType != null ? !this.proxyType.equals(proxyType.proxyType) : proxyType.proxyType != null);
        }

        public int hashCode() {
            return this.proxyType.hashCode();
        }
    }
}

