/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class SftpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private Session session;
    private ChannelSftp idleChannel;

    protected SftpFileSystem(GenericFileName genericFileName, Session session, FileSystemOptions fileSystemOptions) {
        super(genericFileName, null, fileSystemOptions);
        this.session = session;
    }

    @Override
    protected void doCloseCommunicationLink() {
        if (this.idleChannel != null) {
            this.idleChannel.disconnect();
            this.idleChannel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    protected ChannelSftp getChannel() throws IOException {
        Runnable runnable;
        Object object;
        Object object2;
        if (this.session == null || !this.session.isConnected()) {
            this.doCloseCommunicationLink();
            object2 = null;
            try {
                try {
                    object = (GenericFileName)this.getRootName();
                    object2 = UserAuthenticatorUtils.authenticate(this.getFileSystemOptions(), SftpFileProvider.AUTHENTICATOR_TYPES);
                    runnable = SftpClientFactory.createConnection(((GenericFileName)object).getHostName(), ((GenericFileName)object).getPort(), UserAuthenticatorUtils.getData((UserAuthenticationData)object2, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(((GenericFileName)object).getUserName())), UserAuthenticatorUtils.getData((UserAuthenticationData)object2, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(((GenericFileName)object).getPassword())), this.getFileSystemOptions());
                }
                catch (Exception exception) {
                    throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                UserAuthenticatorUtils.cleanup(object2);
                throw throwable;
            }
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)object2);
            this.session = runnable;
        }
        try {
            if (this.idleChannel != null) {
                runnable = this.idleChannel;
                this.idleChannel = null;
            } else {
                runnable = (ChannelSftp)this.session.openChannel("sftp");
                runnable.connect();
                object2 = SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                object = this.getRootName().getPath();
                if (!(object == null || object2 != null && ((Boolean)object2).booleanValue())) {
                    try {
                        runnable.cd((String)object);
                    }
                    catch (SftpException sftpException) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", object);
                    }
                }
            }
            return runnable;
        }
        catch (JSchException jSchException) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)jSchException);
        }
    }

    protected void putChannel(ChannelSftp channelSftp) {
        if (this.idleChannel == null) {
            if (channelSftp.isConnected() && !channelSftp.isClosed()) {
                this.idleChannel = channelSftp;
            }
        } else {
            channelSftp.disconnect();
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(SftpFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws FileSystemException {
        return new SftpFileObject(abstractFileName, this);
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 1000.0;
    }
}

