/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.provider.sftp.SftpRandomAccessContent;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.eclipse.core.runtime.IProgressMonitor;

public class SftpFileObject
extends AbstractFileObject
implements FileObject {
    private final SftpFileSystem fileSystem;
    private SftpATTRS attrs;
    private final String relPath;
    private boolean inRefresh;

    protected SftpFileObject(AbstractFileName abstractFileName, SftpFileSystem sftpFileSystem) throws FileSystemException {
        super(abstractFileName, sftpFileSystem);
        this.fileSystem = sftpFileSystem;
        this.relPath = UriParser.decode(sftpFileSystem.getRootName().getRelativeName(abstractFileName));
    }

    public void createSymbolicLink(String string, String string2) throws IOException {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            channelSftp.symlink(string, string2);
        }
        catch (SftpException sftpException) {
            throw new IOException(sftpException);
        }
    }

    public String readSymbolicLink() throws IOException {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            String string = this.getName().getPath();
            return channelSftp.readlink(string);
        }
        catch (SftpException sftpException) {
            throw new IOException(sftpException);
        }
    }

    public SftpATTRS getAttributes() {
        return this.attrs;
    }

    public void setAttributes(long l, int n) throws IOException, SftpException {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            if (l != 0L) {
                int n2 = (int)(l / 1000L);
                this.attrs.setACMODTIME(this.attrs.getATime(), n2);
                channelSftp.setStat(this.relPath, this.attrs);
            }
            channelSftp.chmod(n, this.relPath);
            this.attrs.setPERMISSIONS(n);
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    @Override
    protected void doDetach() throws Exception {
        this.attrs = null;
    }

    @Override
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                try {
                    this.attrs = null;
                    this.getType();
                }
                catch (IOException iOException) {
                    throw new FileSystemException(iOException);
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    @Override
    protected FileType doGetType() throws Exception {
        if (this.attrs == null) {
            this.statSelf();
        }
        if (this.attrs == null) {
            return FileType.IMAGINARY;
        }
        if ((this.attrs.getFlags() & 4) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-permissions.error");
        }
        if (this.attrs.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected void onChange() throws Exception {
        this.statSelf();
    }

    private void statSelf() throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            try {
                this.setStat(channelSftp.stat(this.relPath));
            }
            catch (SftpException sftpException) {
                try {
                    if (sftpException.id != 2) {
                        channelSftp.disconnect();
                        channelSftp = this.fileSystem.getChannel();
                        this.setStat(channelSftp.stat(this.relPath));
                    } else {
                        this.attrs = null;
                    }
                }
                catch (SftpException sftpException2) {
                    this.attrs = null;
                }
                this.fileSystem.putChannel(channelSftp);
            }
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    private void setStat(SftpATTRS sftpATTRS) {
        this.attrs = sftpATTRS;
    }

    @Override
    protected void doCreateFolder() throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            channelSftp.mkdir(this.relPath);
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 8) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-modtime.error");
        }
        return (long)this.attrs.getMTime() * 1000L;
    }

    @Override
    protected boolean doSetLastModifiedTime(long l) throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            int n = (int)(l / 1000L);
            this.attrs.setACMODTIME(this.attrs.getATime(), n);
            channelSftp.setStat(this.relPath, this.attrs);
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
        return true;
    }

    @Override
    protected void doDelete(IProgressMonitor iProgressMonitor) throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            if (this.getType() == FileType.FILE) {
                channelSftp.rm(this.relPath);
            } else {
                channelSftp.rmdir(this.relPath);
            }
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    @Override
    protected void doRename(FileObject fileObject, IProgressMonitor iProgressMonitor) throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            channelSftp.rename(this.relPath, ((SftpFileObject)fileObject).relPath);
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    @Override
    protected FileObject[] doListChildrenResolved(IProgressMonitor iProgressMonitor) throws Exception {
        Object object;
        Vector vector;
        block28: {
            block27: {
                vector = null;
                ChannelSftp channelSftp = this.fileSystem.getChannel();
                try {
                    vector = channelSftp.ls(this.relPath);
                }
                catch (SftpException sftpException) {
                    object = null;
                    try {
                        if (this.relPath != null) {
                            object = channelSftp.pwd();
                            channelSftp.cd(this.relPath);
                        }
                    }
                    catch (SftpException sftpException2) {
                        this.fileSystem.putChannel(channelSftp);
                        return null;
                    }
                    try {
                        Object object2;
                        block26: {
                            object2 = null;
                            try {
                                try {
                                    vector = channelSftp.ls(".");
                                }
                                catch (SftpException sftpException3) {
                                    object2 = sftpException3;
                                    try {
                                        if (this.relPath != null) {
                                            channelSftp.cd((String)object);
                                        }
                                        break block26;
                                    }
                                    catch (SftpException sftpException4) {
                                        throw new FileSystemException("vfs.provider.sftp/change-work-directory-back.error", object, (Throwable)object2);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (this.relPath != null) {
                                        channelSftp.cd((String)object);
                                    }
                                }
                                catch (SftpException sftpException5) {
                                    throw new FileSystemException("vfs.provider.sftp/change-work-directory-back.error", object, (Throwable)object2);
                                }
                                throw throwable;
                            }
                            try {
                                if (this.relPath != null) {
                                    channelSftp.cd((String)object);
                                }
                            }
                            catch (SftpException sftpException6) {
                                throw new FileSystemException("vfs.provider.sftp/change-work-directory-back.error", object, (Throwable)object2);
                            }
                        }
                        if (object2 != null) {
                            throw object2;
                        }
                        break block27;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.fileSystem.putChannel(channelSftp);
                    }
                }
                this.fileSystem.putChannel(channelSftp);
            }
            if (vector != null) break block28;
            throw new FileSystemException("vfs.provider.sftp/list-children.error");
        }
        object = new ArrayList();
        for (ChannelSftp.LsEntry lsEntry : vector) {
            String string = lsEntry.getFilename();
            if (VFS.isUriStyle() && lsEntry.getAttrs().isDir() && string.charAt(string.length() - 1) != '/') {
                string = String.valueOf(string) + "/";
            }
            if (string.equals(".") || string.equals("..") || string.equals("./") || string.equals("../")) continue;
            FileObject fileObject = this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), UriParser.encode(string), NameScope.CHILD));
            ((SftpFileObject)FileObjectUtils.getAbstractFileObject(fileObject)).setStat(lsEntry.getAttrs());
            ((ArrayList)object).add(fileObject);
        }
        return ((ArrayList)object).toArray(new FileObject[((ArrayList)object).size()]);
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) throws Exception {
        return null;
    }

    @Override
    protected long doGetContentSize() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 1) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return this.attrs.getSize();
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new SftpRandomAccessContent(this, randomAccessMode);
    }

    InputStream getInputStream(long l) throws IOException {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                channelSftp.get(this.getName().getPathDecoded(), byteArrayOutputStream, null, 1, l);
            }
            catch (SftpException sftpException) {
                throw new FileSystemException(sftpException);
            }
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream doGetInputStream() throws Exception {
        SftpFileSystem sftpFileSystem = this.fileSystem;
        synchronized (sftpFileSystem) {
            InputStream inputStream;
            ChannelSftp channelSftp = this.fileSystem.getChannel();
            try {
                if (!this.getType().hasContent()) {
                    throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
                }
                inputStream = channelSftp.get(this.relPath);
            }
            catch (SftpException sftpException) {
                if (sftpException.id == 2) {
                    throw new FileNotFoundException(this.getName());
                }
                throw new FileSystemException(sftpException);
            }
            return new SftpInputStream(channelSftp, inputStream);
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        return new SftpOutputStream(channelSftp, channelSftp.put(this.relPath));
    }

    private class SftpInputStream
    extends MonitorInputStream {
        private final ChannelSftp channel;

        public SftpInputStream(ChannelSftp channelSftp, InputStream inputStream) {
            super(inputStream);
            this.channel = channelSftp;
        }

        @Override
        protected void onClose() throws IOException {
            SftpFileObject.this.fileSystem.putChannel(this.channel);
        }
    }

    private class SftpOutputStream
    extends MonitorOutputStream {
        private final ChannelSftp channel;

        public SftpOutputStream(ChannelSftp channelSftp, OutputStream outputStream) {
            super(outputStream);
            this.channel = channelSftp;
        }

        @Override
        protected void onClose() throws IOException {
            SftpFileObject.this.fileSystem.putChannel(this.channel);
        }
    }
}

