/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.Os;

public final class SftpClientFactory {
    private static final String SSH_DIR_NAME = ".ssh";

    private SftpClientFactory() {
    }

    public static Session createConnection(String string, int n, char[] cArray, char[] cArray2, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Object object;
        Object object2;
        JSch jSch = new JSch();
        File file = null;
        SftpFileSystemConfigBuilder sftpFileSystemConfigBuilder = SftpFileSystemConfigBuilder.getInstance();
        File file2 = sftpFileSystemConfigBuilder.getKnownHosts(fileSystemOptions);
        Set<IdentityInfo> set = sftpFileSystemConfigBuilder.getIdentities(fileSystemOptions);
        if (file2 != null) {
            try {
                jSch.setKnownHosts(file2.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                throw new FileSystemException("vfs.provider.sftp/known-hosts.error", file2.getAbsolutePath(), (Throwable)jSchException);
            }
        }
        file = SftpClientFactory.findSshDir();
        file2 = new File(file, "known_hosts");
        if (file2.isFile() && file2.canRead()) {
            try {
                jSch.setKnownHosts(file2.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                throw new FileSystemException("vfs.provider.sftp/known-hosts.error", file2.getAbsolutePath(), (Throwable)jSchException);
            }
        }
        if (set != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    ((IdentityInfo)object).addTo(jSch);
                }
                catch (JSchException jSchException) {
                    throw new FileSystemException("vfs.provider.sftp/load-private-key.error", object, (Throwable)jSchException);
                }
            }
        }
        try {
            String string2;
            String string3;
            String string4;
            UserInfo userInfo;
            object = jSch.getSession(new String(cArray), string, n);
            if (cArray2 != null) {
                ((Session)object).setPassword(new String(cArray2));
            }
            if ((object2 = sftpFileSystemConfigBuilder.getTimeout(fileSystemOptions)) != null) {
                ((Session)object).setTimeout((Integer)object2);
            }
            if ((userInfo = sftpFileSystemConfigBuilder.getUserInfo(fileSystemOptions)) != null) {
                ((Session)object).setUserInfo(userInfo);
            }
            Properties properties = new Properties();
            String string5 = sftpFileSystemConfigBuilder.getStrictHostKeyChecking(fileSystemOptions);
            if (string5 != null) {
                properties.setProperty("StrictHostKeyChecking", string5);
            }
            if ((string4 = sftpFileSystemConfigBuilder.getPreferredAuthentications(fileSystemOptions)) != null) {
                properties.setProperty("PreferredAuthentications", string4);
            }
            if ((string3 = sftpFileSystemConfigBuilder.getCompression(fileSystemOptions)) != null) {
                properties.setProperty("compression.s2c", string3);
                properties.setProperty("compression.c2s", string3);
            }
            if ((string2 = sftpFileSystemConfigBuilder.getProxyHost(fileSystemOptions)) != null) {
                int n2 = sftpFileSystemConfigBuilder.getProxyPort(fileSystemOptions);
                SftpFileSystemConfigBuilder.ProxyType proxyType = sftpFileSystemConfigBuilder.getProxyType(fileSystemOptions);
                Proxy proxy = null;
                if (SftpFileSystemConfigBuilder.PROXY_HTTP.equals(proxyType)) {
                    proxy = n2 != 0 ? new ProxyHTTP(string2, n2) : new ProxyHTTP(string2);
                } else if (SftpFileSystemConfigBuilder.PROXY_SOCKS5.equals(proxyType)) {
                    proxy = n2 != 0 ? new ProxySOCKS5(string2, n2) : new ProxySOCKS5(string2);
                }
                if (proxy != null) {
                    ((Session)object).setProxy(proxy);
                }
            }
            if (properties.size() > 0) {
                ((Session)object).setConfig(properties);
            }
            ((Session)object).setDaemonThread(true);
            ((Session)object).connect();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", new Object[]{string}, (Throwable)exception);
        }
        return object;
    }

    private static File findSshDir() {
        String string;
        File file;
        String string2 = System.getProperty("vfs.sftp.sshdir");
        if (string2 != null && (file = new File(string2)).exists()) {
            return file;
        }
        file = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (file.exists()) {
            return file;
        }
        if (Os.isFamily(Os.OS_FAMILY_WINDOWS) && (file = new File("C:\\cygwin\\home\\" + (string = System.getProperty("user.name")) + "\\" + SSH_DIR_NAME)).exists()) {
            return file;
        }
        return new File("");
    }
}

