/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;

public class IdentityInfo {
    private final String privateKeyFile;
    private final byte[] passphrase;

    public IdentityInfo(String string, byte[] byArray) throws IllegalArgumentException {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("privateKeyFile");
        }
        this.privateKeyFile = string;
        this.passphrase = byArray != null && byArray.length > 0 ? byArray : null;
    }

    public final String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public final byte[] getPassphrase() {
        return this.passphrase;
    }

    public final boolean hasPassphrase() {
        return this.passphrase != null;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IdentityInfo identityInfo = (IdentityInfo)object;
        return this.privateKeyFile.equals(identityInfo.privateKeyFile);
    }

    public final int hashCode() {
        return this.privateKeyFile.hashCode();
    }

    public String toString() {
        return "file=" + this.privateKeyFile + ", " + (this.hasPassphrase() ? "HasPassphrase" : "NoPassphrase");
    }

    public void addTo(JSch jSch) throws JSchException, NullPointerException {
        jSch.addIdentity(this.getPrivateKeyFile(), this.getPassphrase());
    }
}

