/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.res.ResourceFileSystemConfigBuilder;

public class ResourceFileProvider
extends AbstractFileProvider {
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.DISPATCHER));

    @Override
    public FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        URL uRL;
        StringBuilder stringBuilder = new StringBuilder(80);
        UriParser.extractScheme(string, stringBuilder);
        String string2 = stringBuilder.toString();
        ClassLoader classLoader = ResourceFileSystemConfigBuilder.getInstance().getClassLoader(fileSystemOptions);
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((uRL = classLoader.getResource(string2)) == null) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", string);
        }
        FileObject fileObject2 = this.getContext().getFileSystemManager().resolveFile(uRL.toExternalForm());
        return fileObject2;
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    @Override
    public void closeFileSystem(FileSystem fileSystem) {
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

