/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.ram.RamFileData;
import org.apache.commons.vfs2.provider.ram.RamFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;

public class RamFileSystem
extends AbstractFileSystem
implements Serializable {
    private static final long serialVersionUID = 20101208L;
    private final Map<FileName, RamFileData> cache = Collections.synchronizedMap(new HashMap());

    protected RamFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) {
        super(fileName, null, fileSystemOptions);
        RamFileData ramFileData = new RamFileData(fileName);
        ramFileData.setType(FileType.FOLDER);
        ramFileData.setLastModified(System.currentTimeMillis());
        this.cache.put(fileName, ramFileData);
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws Exception {
        RamFileObject ramFileObject = new RamFileObject(abstractFileName, this);
        return ramFileObject;
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(RamFileProvider.capabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] listChildren(FileName fileName) {
        String[] stringArray;
        Collection<RamFileData> collection;
        RamFileData ramFileData = this.cache.get(fileName);
        if (ramFileData == null || !ramFileData.getType().hasChildren()) {
            return null;
        }
        Collection<RamFileData> collection2 = collection = ramFileData.getChildren();
        synchronized (collection2) {
            stringArray = new String[collection.size()];
            int n = 0;
            for (RamFileData ramFileData2 : collection) {
                stringArray[n] = ramFileData2.getName().getBaseName();
                ++n;
            }
        }
        return stringArray;
    }

    void delete(RamFileObject ramFileObject) throws FileSystemException {
        if (ramFileObject.getParent() == null) {
            throw new FileSystemException("unable to delete root");
        }
        this.cache.remove(ramFileObject.getName());
        RamFileObject ramFileObject2 = (RamFileObject)this.resolveFile(ramFileObject.getParent().getName());
        ramFileObject2.getData().removeChild(ramFileObject.getData());
        ramFileObject2.close();
        ramFileObject.getData().clear();
        ramFileObject.close();
    }

    void save(RamFileObject ramFileObject) throws FileSystemException {
        RamFileData ramFileData;
        if (ramFileObject.getData().getName() == null) {
            throw new FileSystemException(new IllegalStateException("The data has no name. " + ramFileObject));
        }
        if (ramFileObject.getName().getDepth() > 0 && !(ramFileData = this.cache.get(ramFileObject.getParent().getName())).hasChildren(ramFileObject.getData())) {
            RamFileObject ramFileObject2 = (RamFileObject)ramFileObject.getParent();
            ramFileObject2.getData().addChild(ramFileObject.getData());
            ramFileObject2.close();
        }
        this.cache.put(ramFileObject.getName(), ramFileObject.getData());
        ramFileObject.getData().updateLastModified();
        ramFileObject.close();
    }

    void rename(RamFileObject ramFileObject, RamFileObject ramFileObject2) throws FileSystemException {
        if (!this.cache.containsKey(ramFileObject.getName())) {
            throw new FileSystemException("File does not exist: " + ramFileObject.getName());
        }
        ramFileObject2.getData().setBuffer(ramFileObject.getData().getBuffer());
        ramFileObject2.getData().setLastModified(ramFileObject.getData().getLastModified());
        ramFileObject2.getData().setType(ramFileObject.getData().getType());
        this.save(ramFileObject2);
        this.delete(ramFileObject);
    }

    public void attach(RamFileObject ramFileObject) {
        if (ramFileObject.getName() == null) {
            throw new IllegalArgumentException("Null argument");
        }
        RamFileData ramFileData = this.cache.get(ramFileObject.getName());
        if (ramFileData == null) {
            ramFileData = new RamFileData(ramFileObject.getName());
        }
        ramFileObject.setData(ramFileData);
    }

    public void importTree(File file) throws FileSystemException {
        FileObject fileObject = this.getFileSystemManager().toFileObject(file);
        this.toRamFileObject(fileObject, fileObject);
    }

    void toRamFileObject(FileObject fileObject, FileObject fileObject2) throws FileSystemException {
        RamFileObject ramFileObject = (RamFileObject)this.resolveFile(fileObject.getName().getPath().substring(fileObject2.getName().getPath().length()));
        if (fileObject.getType().hasChildren()) {
            ramFileObject.createFolder();
            FileObject[] fileObjectArray = fileObject.getChildren(null);
            int n = 0;
            while (n < fileObjectArray.length) {
                FileObject fileObject3 = fileObjectArray[n];
                this.toRamFileObject(fileObject3, fileObject2);
                ++n;
            }
        } else if (fileObject.getType().equals((Object)FileType.FILE)) {
            try {
                InputStream inputStream = fileObject.getContent().getInputStream();
                try {
                    int n;
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(ramFileObject.getOutputStream(), 512);
                    while ((n = inputStream.read()) != -1) {
                        ((OutputStream)bufferedOutputStream).write(n);
                    }
                    ((OutputStream)bufferedOutputStream).flush();
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                throw new FileSystemException(String.valueOf(iOException.getClass().getName()) + " " + iOException.getMessage());
            }
        } else {
            throw new FileSystemException("File is not a folder nor a file " + ramFileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        int n = 0;
        Map<FileName, RamFileData> map = this.cache;
        synchronized (map) {
            for (RamFileData ramFileData : this.cache.values()) {
                n += ramFileData.size();
            }
        }
        return n;
    }

    @Override
    public void close() {
        this.cache.clear();
        super.close();
    }
}

