/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.ram.RamFileObject;

public class RamFileOutputStream
extends OutputStream {
    protected RamFileObject file;
    protected byte[] buffer1 = new byte[1];
    protected boolean closed = false;
    private IOException exc;

    public RamFileOutputStream(RamFileObject ramFileObject) {
        this.file = ramFileObject;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.file.getData().size();
        int n4 = this.file.getData().size() + n2;
        try {
            this.file.resize(n4);
        }
        catch (IOException iOException) {
            this.exc = iOException;
            throw iOException;
        }
        System.arraycopy(byArray, n, this.file.getData().getBuffer(), n3, n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer1[0] = (byte)n;
        this.write(this.buffer1);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.exc != null) {
            throw this.exc;
        }
        try {
            this.closed = true;
            this.file.endOutput();
        }
        catch (Exception exception) {
            throw new FileSystemException(exception);
        }
    }
}

