/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.local.LocalFileNameParser;
import org.apache.commons.vfs2.provider.local.WindowsFileName;

public class WindowsFileNameParser
extends LocalFileNameParser {
    @Override
    protected String extractRootPrefix(String string, StringBuilder stringBuilder) throws FileSystemException {
        return this.extractWindowsRootPrefix(string, stringBuilder);
    }

    @Override
    protected FileName createFileName(String string, String string2, String string3, FileType fileType) {
        return new WindowsFileName(string, string2, string3, fileType);
    }

    private String extractWindowsRootPrefix(String string, StringBuilder stringBuilder) throws FileSystemException {
        int n = 0;
        int n2 = Math.min(4, stringBuilder.length());
        while (n < n2 && stringBuilder.charAt(n) == '/') {
            ++n;
        }
        if (n == n2 && stringBuilder.length() > n && stringBuilder.charAt(n + 1) == '/') {
            throw new FileSystemException("vfs.provider.local/not-absolute-file-name.error", string);
        }
        stringBuilder.delete(0, n);
        String string2 = this.extractDrivePrefix(stringBuilder);
        if (string2 != null) {
            return string2;
        }
        if (n < 2) {
            throw new FileSystemException("vfs.provider.local/not-absolute-file-name.error", string);
        }
        return "//" + this.extractUNCPrefix(string, stringBuilder);
    }

    private String extractDrivePrefix(StringBuilder stringBuilder) {
        if (stringBuilder.length() < 3) {
            return null;
        }
        char c = stringBuilder.charAt(0);
        if (c == '/' || c == ':') {
            return null;
        }
        if (stringBuilder.charAt(1) != ':') {
            return null;
        }
        if (stringBuilder.charAt(2) != '/') {
            return null;
        }
        String string = stringBuilder.substring(0, 2);
        stringBuilder.delete(0, 2);
        return string.intern();
    }

    private String extractUNCPrefix(String string, StringBuilder stringBuilder) throws FileSystemException {
        int n = stringBuilder.length();
        int n2 = 0;
        while (n2 < n && stringBuilder.charAt(n2) != '/') {
            ++n2;
        }
        if (++n2 >= n) {
            throw new FileSystemException("vfs.provider.local/missing-share-name.error", string);
        }
        int n3 = n2;
        while (n2 < n && stringBuilder.charAt(n2) != '/') {
            ++n2;
        }
        if (n2 == n3) {
            throw new FileSystemException("vfs.provider.local/missing-share-name.error", string);
        }
        String string2 = stringBuilder.substring(0, n2);
        stringBuilder.delete(0, n2);
        return string2;
    }
}

