/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.io.FilePermission;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final String rootFile;

    public LocalFileSystem(FileName fileName, String string, FileSystemOptions fileSystemOptions) {
        super(fileName, null, fileSystemOptions);
        this.rootFile = string;
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws FileSystemException {
        return new LocalFile(this, this.rootFile, abstractFileName);
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(DefaultLocalFileProvider.capabilities);
    }

    @Override
    protected File doReplicateFile(FileObject fileObject, FileSelector fileSelector, IProgressMonitor iProgressMonitor) throws Exception {
        LocalFile localFile = (LocalFile)fileObject;
        File file = localFile.getLocalFile();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            FilePermission filePermission = new FilePermission(file.getAbsolutePath(), "read");
            securityManager.checkPermission(filePermission);
        }
        return file;
    }
}

