/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

class LocalFileRandomAccessContent
extends AbstractRandomAccessContent {
    private final RandomAccessFile raf;
    private final InputStream rafis;

    LocalFileRandomAccessContent(File file, RandomAccessMode randomAccessMode) throws FileSystemException {
        super(randomAccessMode);
        try {
            this.raf = new RandomAccessFile(file, randomAccessMode.getModeString());
            this.rafis = new InputStream(){

                @Override
                public int read() throws IOException {
                    try {
                        return LocalFileRandomAccessContent.this.raf.readByte();
                    }
                    catch (EOFException eOFException) {
                        return -1;
                    }
                }

                @Override
                public long skip(long l) throws IOException {
                    LocalFileRandomAccessContent.this.raf.seek(LocalFileRandomAccessContent.this.raf.getFilePointer() + l);
                    return l;
                }

                @Override
                public void close() throws IOException {
                    LocalFileRandomAccessContent.this.raf.close();
                }

                @Override
                public int read(byte[] byArray) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(byArray);
                }

                @Override
                public int read(byte[] byArray, int n, int n2) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(byArray, n, n2);
                }

                @Override
                public int available() throws IOException {
                    long l = LocalFileRandomAccessContent.this.raf.length() - LocalFileRandomAccessContent.this.raf.getFilePointer();
                    if (l > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)l;
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileSystemException("vfs.provider/random-access-open-failed.error", file);
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public void seek(long l) throws IOException {
        this.raf.seek(l);
    }

    @Override
    public long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    @Override
    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    @Override
    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.raf.readFully(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.raf.readFully(byArray, n, n2);
    }

    @Override
    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.raf.writeDouble(d);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.raf.writeFloat(f);
    }

    @Override
    public void write(int n) throws IOException {
        this.raf.write(n);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.raf.writeByte(n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.raf.writeChar(n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.raf.writeInt(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.raf.writeShort(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.raf.writeLong(l);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.raf.writeBoolean(bl);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.raf.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.raf.write(byArray, n, n2);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.raf.writeBytes(string);
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.raf.writeChars(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.raf.writeUTF(string);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }
}

