/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public abstract class LocalFileNameParser
extends AbstractFileNameParser {
    public boolean isAbsoluteName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        try {
            UriParser.fixSeparators(stringBuilder);
            this.extractRootPrefix(string, stringBuilder);
            return true;
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    protected abstract String extractRootPrefix(String var1, StringBuilder var2) throws FileSystemException;

    @Override
    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = UriParser.extractScheme(string, stringBuilder);
        if (string2 == null) {
            string2 = "file";
        }
        UriParser.canonicalizePath(stringBuilder, 0, stringBuilder.length(), this);
        UriParser.fixSeparators(stringBuilder);
        String string3 = this.extractRootPrefix(string, stringBuilder);
        FileType fileType = UriParser.normalisePath(stringBuilder);
        String string4 = stringBuilder.toString();
        return this.createFileName(string2, string3, string4, fileType);
    }

    protected abstract FileName createFileName(String var1, String var2, String var3, FileType var4);
}

