/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.jar.JarFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;

public class JarFileProvider
extends ZipFileProvider {
    static final Collection<Capability> capabilities;

    static {
        ArrayList<Capability> arrayList = new ArrayList<Capability>();
        arrayList.addAll(ZipFileProvider.capabilities);
        arrayList.addAll(Arrays.asList(Capability.ATTRIBUTES, Capability.FS_ATTRIBUTES, Capability.SIGNING, Capability.MANIFEST_ATTRIBUTES, Capability.VIRTUAL));
        capabilities = Collections.unmodifiableCollection(arrayList);
    }

    @Override
    protected FileSystem doCreateFileSystem(String string, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName layeredFileName = new LayeredFileName(string, fileObject.getName(), "/", FileType.FOLDER);
        return new JarFileSystem(layeredFileName, fileObject, fileSystemOptions);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

