/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.jar.JarFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;

public class JarFileObject
extends ZipFileObject {
    private final JarFileSystem fs;
    private Attributes attributes;

    protected JarFileObject(AbstractFileName abstractFileName, ZipEntry zipEntry, JarFileSystem jarFileSystem, boolean bl) throws FileSystemException {
        super(abstractFileName, zipEntry, jarFileSystem, bl);
        this.fs = jarFileSystem;
        try {
            this.getAttributes();
        }
        catch (IOException iOException) {
            throw new FileSystemException(iOException);
        }
    }

    Manifest getManifest() throws IOException {
        if (this.fs.getZipFile() == null) {
            return null;
        }
        return ((JarFile)this.fs.getZipFile()).getManifest();
    }

    Attributes getAttributes() throws IOException {
        if (this.attributes == null) {
            if (this.entry == null) {
                this.attributes = new Attributes(1);
            } else {
                this.attributes = ((JarEntry)this.entry).getAttributes();
                if (this.attributes == null) {
                    this.attributes = new Attributes(1);
                }
            }
        }
        return this.attributes;
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JarFileSystem jarFileSystem = (JarFileSystem)this.getFileSystem();
        this.addAll(jarFileSystem.getAttributes(), hashMap);
        this.addAll(this.getAttributes(), hashMap);
        return hashMap;
    }

    private void addAll(Attributes attributes, Map<String, Object> map) {
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string = entry.getKey().toString();
            map.put(string, entry.getValue());
        }
    }

    @Override
    protected Certificate[] doGetCertificates() {
        if (this.entry == null) {
            return null;
        }
        return ((JarEntry)this.entry).getCertificates();
    }
}

