/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpParams;

public class ThreadLocalHttpConnectionManager
implements HttpConnectionManager {
    protected ThreadLocal localHttpConnection = new ThreadLocal(){

        protected Object initialValue() {
            return new Entry();
        }
    };
    private HttpConnectionManagerParams params = new HttpConnectionManagerParams();

    static void finishLastResponse(HttpConnection httpConnection) {
        InputStream inputStream = httpConnection.getLastResponseInputStream();
        if (inputStream != null) {
            httpConnection.setLastResponseInputStream(null);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                httpConnection.close();
            }
        }
    }

    public void releaseLocalConnection() {
        if (this.getLocalHttpConnection() != null) {
            this.releaseConnection(this.getLocalHttpConnection());
        }
    }

    protected HttpConnection getLocalHttpConnection() {
        return ((Entry)this.localHttpConnection.get()).conn;
    }

    protected void setLocalHttpConnection(HttpConnection httpConnection) {
        ((Entry)this.localHttpConnection.get()).conn = httpConnection;
    }

    protected long getIdleStartTime() {
        return ((Entry)this.localHttpConnection.get()).idleStartTime;
    }

    protected void setIdleStartTime(long l) {
        ((Entry)this.localHttpConnection.get()).idleStartTime = l;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        return this.getConnection(hostConfiguration, 0L);
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.params.isStaleCheckingEnabled();
    }

    public void setConnectionStaleCheckingEnabled(boolean bl) {
        this.params.setStaleCheckingEnabled(bl);
    }

    public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long l) {
        HttpConnection httpConnection = this.getLocalHttpConnection();
        if (httpConnection == null) {
            httpConnection = new HttpConnection(hostConfiguration);
            this.setLocalHttpConnection(httpConnection);
            httpConnection.setHttpConnectionManager((HttpConnectionManager)this);
            httpConnection.getParams().setDefaults((HttpParams)this.params);
        } else if (!hostConfiguration.hostEquals(httpConnection) || !hostConfiguration.proxyEquals(httpConnection)) {
            if (httpConnection.isOpen()) {
                httpConnection.close();
            }
            httpConnection.setHost(hostConfiguration.getHost());
            httpConnection.setPort(hostConfiguration.getPort());
            httpConnection.setProtocol(hostConfiguration.getProtocol());
            httpConnection.setLocalAddress(hostConfiguration.getLocalAddress());
            httpConnection.setProxyHost(hostConfiguration.getProxyHost());
            httpConnection.setProxyPort(hostConfiguration.getProxyPort());
        } else {
            ThreadLocalHttpConnectionManager.finishLastResponse(httpConnection);
        }
        this.setIdleStartTime(Long.MAX_VALUE);
        return httpConnection;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long l) {
        return this.getConnectionWithTimeout(hostConfiguration, l);
    }

    public void releaseConnection(HttpConnection httpConnection) {
        if (httpConnection != this.getLocalHttpConnection()) {
            throw new IllegalStateException("Unexpected release of an unknown connection.");
        }
        ThreadLocalHttpConnectionManager.finishLastResponse(this.getLocalHttpConnection());
        this.setIdleStartTime(System.currentTimeMillis());
    }

    public void closeIdleConnections(long l) {
        long l2 = System.currentTimeMillis() - l;
        if (this.getIdleStartTime() <= l2) {
            this.getLocalHttpConnection().close();
        }
    }

    public HttpConnectionManagerParams getParams() {
        return this.params;
    }

    public void setParams(HttpConnectionManagerParams httpConnectionManagerParams) {
        if (httpConnectionManagerParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = httpConnectionManagerParams;
    }

    private static class Entry {
        private HttpConnection conn = null;
        private long idleStartTime = Long.MAX_VALUE;

        private Entry() {
        }
    }
}

