/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.http.HttpFileSystem;

public class HttpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final HttpFileSystemConfigBuilder BUILDER = new HttpFileSystemConfigBuilder();
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 5;
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final String OPTION_NAME_PREEMPTIVE_AUTHENTICATION = "preemptiveAuth";

    protected HttpFileSystemConfigBuilder(String string) {
        super(string);
    }

    private HttpFileSystemConfigBuilder() {
        super("http.");
    }

    public static HttpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setUrlCharset(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "urlCharset", string);
    }

    public String getUrlCharset(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "urlCharset");
    }

    public void setProxyHost(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "proxyHost", string);
    }

    public void setProxyPort(FileSystemOptions fileSystemOptions, int n) {
        this.setParam(fileSystemOptions, "proxyPort", new Integer(n));
    }

    public String getProxyHost(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, "proxyPort", 0);
    }

    public void setProxyAuthenticator(FileSystemOptions fileSystemOptions, UserAuthenticator userAuthenticator) {
        this.setParam(fileSystemOptions, "proxyAuthenticator", userAuthenticator);
    }

    public UserAuthenticator getProxyAuthenticator(FileSystemOptions fileSystemOptions) {
        return (UserAuthenticator)this.getParam(fileSystemOptions, "proxyAuthenticator");
    }

    public void setCookies(FileSystemOptions fileSystemOptions, Cookie[] cookieArray) {
        this.setParam(fileSystemOptions, "cookies", cookieArray);
    }

    public Cookie[] getCookies(FileSystemOptions fileSystemOptions) {
        return (Cookie[])this.getParam(fileSystemOptions, "cookies");
    }

    public void setMaxTotalConnections(FileSystemOptions fileSystemOptions, int n) {
        this.setParam(fileSystemOptions, "http.connection-manager.max-total", new Integer(n));
    }

    public int getMaxTotalConnections(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, "http.connection-manager.max-total", 50);
    }

    public void setMaxConnectionsPerHost(FileSystemOptions fileSystemOptions, int n) {
        this.setParam(fileSystemOptions, "http.connection-manager.max-per-host", new Integer(n));
    }

    public int getMaxConnectionsPerHost(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, "http.connection-manager.max-per-host", 5);
    }

    public boolean isPreemptiveAuth(FileSystemOptions fileSystemOptions) {
        return this.getBoolean(fileSystemOptions, OPTION_NAME_PREEMPTIVE_AUTHENTICATION, Boolean.FALSE);
    }

    public void setPreemptiveAuth(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, OPTION_NAME_PREEMPTIVE_AUTHENTICATION, bl);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return HttpFileSystem.class;
    }
}

