/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;

public class HttpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final HttpClient client;

    protected HttpFileSystem(GenericFileName genericFileName, HttpClient httpClient, FileSystemOptions fileSystemOptions) {
        super(genericFileName, null, fileSystemOptions);
        this.client = httpClient;
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(HttpFileProvider.capabilities);
    }

    protected HttpClient getClient() {
        return this.client;
    }

    @Override
    public void closeCommunicationLink() {
        HttpConnectionManager httpConnectionManager;
        if (this.getClient() != null && (httpConnectionManager = this.getClient().getHttpConnectionManager()) instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)httpConnectionManager).shutdown();
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws Exception {
        return new HttpFileObject(abstractFileName, this);
    }
}

