/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.http.HttpFileContentInfoFactory;
import org.apache.commons.vfs2.provider.http.HttpFileSystem;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.http.HttpRandomAccessContent;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.eclipse.core.runtime.IProgressMonitor;

public class HttpFileObject
extends AbstractFileObject {
    private final HttpFileSystem fileSystem;
    private final String urlCharset;
    private HeadMethod method;

    protected HttpFileObject(AbstractFileName abstractFileName, HttpFileSystem httpFileSystem) {
        super(abstractFileName, httpFileSystem);
        this.fileSystem = httpFileSystem;
        this.urlCharset = HttpFileSystemConfigBuilder.getInstance().getUrlCharset(this.getFileSystem().getFileSystemOptions());
    }

    @Override
    protected void doDetach() throws Exception {
        this.method = null;
    }

    @Override
    protected FileType doGetType() throws Exception {
        this.method = new HeadMethod();
        this.setupMethod((HttpMethod)this.method);
        HttpClient httpClient = this.fileSystem.getClient();
        int n = httpClient.executeMethod((HttpMethod)this.method);
        this.method.releaseConnection();
        if (n == 200) {
            return FileType.FILE;
        }
        if (n == 404 || n == 410) {
            return FileType.IMAGINARY;
        }
        throw new FileSystemException("vfs.provider.http/head.error", this.getName());
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) throws Exception {
        throw new Exception("Not implemented.");
    }

    @Override
    protected long doGetContentSize() throws Exception {
        Header header = this.method.getResponseHeader("content-length");
        if (header == null) {
            return 0L;
        }
        return Long.parseLong(header.getValue());
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        Header header = this.method.getResponseHeader("last-modified");
        if (header == null) {
            throw new FileSystemException("vfs.provider.http/last-modified.error", this.getName());
        }
        return DateUtil.parseDate((String)header.getValue()).getTime();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        GetMethod getMethod = new GetMethod();
        this.setupMethod((HttpMethod)getMethod);
        int n = this.fileSystem.getClient().executeMethod((HttpMethod)getMethod);
        if (n == 404) {
            throw new FileNotFoundException(this.getName());
        }
        if (n != 200) {
            throw new FileSystemException("vfs.provider.http/get.error", this.getName());
        }
        return new HttpInputStream(getMethod);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new HttpRandomAccessContent(this, randomAccessMode);
    }

    protected void setupMethod(HttpMethod httpMethod) throws FileSystemException, URIException {
        String string = ((URLFileName)this.getName()).getPathQueryEncoded(this.urlCharset);
        httpMethod.setPath(string);
        httpMethod.setFollowRedirects(true);
        httpMethod.setRequestHeader("User-Agent", "Jakarta-Commons-VFS");
    }

    protected String encodePath(String string) throws URIException {
        String string2 = URIUtil.encodePath((String)string);
        return string2;
    }

    @Override
    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new HttpFileContentInfoFactory();
    }

    HeadMethod getHeadMethod() {
        return this.method;
    }

    static class HttpInputStream
    extends MonitorInputStream {
        private final GetMethod method;

        public HttpInputStream(GetMethod getMethod) throws IOException {
            super(getMethod.getResponseBodyAsStream());
            this.method = getMethod;
        }

        @Override
        protected void onClose() throws IOException {
            this.method.releaseConnection();
        }
    }
}

