/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public final class HttpClientFactory {
    private HttpClientFactory() {
    }

    public static HttpClient createConnection(String string, String string2, int n, String string3, String string4, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return HttpClientFactory.createConnection(HttpFileSystemConfigBuilder.getInstance(), string, string2, n, string3, string4, fileSystemOptions);
    }

    public static HttpClient createConnection(HttpFileSystemConfigBuilder httpFileSystemConfigBuilder, String string, String string2, int n, String string3, String string4, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient httpClient;
        try {
            String string5;
            MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams httpConnectionManagerParams = multiThreadedHttpConnectionManager.getParams();
            httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setHost(string2, n, string);
            if (fileSystemOptions != null) {
                Object object;
                UserAuthenticator userAuthenticator;
                string5 = httpFileSystemConfigBuilder.getProxyHost(fileSystemOptions);
                int n2 = httpFileSystemConfigBuilder.getProxyPort(fileSystemOptions);
                if (string5 != null && string5.length() > 0 && n2 > 0) {
                    hostConfiguration.setProxy(string5, n2);
                }
                if ((userAuthenticator = httpFileSystemConfigBuilder.getProxyAuthenticator(fileSystemOptions)) != null) {
                    HttpClientParams httpClientParams;
                    object = UserAuthenticatorUtils.authenticate(userAuthenticator, new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD});
                    if (object != null) {
                        httpClientParams = new UsernamePasswordCredentials(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData((UserAuthenticationData)object, UserAuthenticationData.USERNAME, null)), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData((UserAuthenticationData)object, UserAuthenticationData.PASSWORD, null)));
                        AuthScope authScope = new AuthScope(string5, -1);
                        httpClient.getState().setProxyCredentials(authScope, (Credentials)httpClientParams);
                    }
                    if (httpFileSystemConfigBuilder.isPreemptiveAuth(fileSystemOptions)) {
                        httpClientParams = new HttpClientParams();
                        httpClientParams.setAuthenticationPreemptive(true);
                        httpClient.setParams(httpClientParams);
                    }
                }
                if ((object = httpFileSystemConfigBuilder.getCookies(fileSystemOptions)) != null) {
                    httpClient.getState().addCookies(object);
                }
            }
            httpConnectionManagerParams.setMaxConnectionsPerHost(hostConfiguration, httpFileSystemConfigBuilder.getMaxConnectionsPerHost(fileSystemOptions));
            httpConnectionManagerParams.setMaxTotalConnections(httpFileSystemConfigBuilder.getMaxTotalConnections(fileSystemOptions));
            httpClient.setHostConfiguration(hostConfiguration);
            if (string3 != null) {
                string5 = new UsernamePasswordCredentials(string3, string4);
                AuthScope authScope = new AuthScope(string2, -1);
                httpClient.getState().setCredentials(authScope, (Credentials)string5);
            }
            httpClient.executeMethod((HttpMethod)new HeadMethod());
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.http/connect.error", new Object[]{string2}, (Throwable)exception);
        }
        return httpClient;
    }
}

