/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.googledrive;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileObject;
import org.apache.commons.vfs2.util.RandomAccessMode;

final class GoogleRandomAccessContent
extends AbstractRandomAccessStreamContent {
    protected DataInputStream dis = null;
    protected final GoogleFileObject fileObject;
    protected long filePointer;
    protected InputStream mis = null;

    GoogleRandomAccessContent(GoogleFileObject googleFileObject, RandomAccessMode randomAccessMode) {
        super(randomAccessMode);
        if (googleFileObject == null) {
            throw new NullPointerException("fileObject");
        }
        this.fileObject = googleFileObject;
    }

    @Override
    public void close() throws IOException {
        if (this.dis != null) {
            this.mis.close();
            DataInputStream dataInputStream = this.dis;
            this.dis = null;
            dataInputStream.close();
            this.mis = null;
        }
    }

    @Override
    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dis != null) {
            return this.dis;
        }
        this.mis = this.fileObject.getInputStream();
        if (this.filePointer > 0L) {
            long l = this.filePointer;
            byte[] byArray = new byte[(int)Math.max(l, 65536L)];
            while (l > 0L) {
                long l2 = this.mis.read(byArray, 0, (int)Math.min((long)byArray.length, l));
                if (l2 < 0L) {
                    throw new IOException("Not enough data to be read, remain=" + l + ", expected=" + this.filePointer);
                }
                l -= l2;
            }
        }
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            @Override
            public void close() throws IOException {
                GoogleRandomAccessContent.this.close();
            }

            @Override
            public int read() throws IOException {
                int n = super.read();
                if (n > -1) {
                    ++GoogleRandomAccessContent.this.filePointer;
                }
                return n;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 > -1) {
                    GoogleRandomAccessContent.this.filePointer += (long)n3;
                }
                return n3;
            }
        });
        return this.dis;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }

    @Override
    public void seek(long l) throws IOException {
        if (l == this.filePointer) {
            return;
        }
        if (l < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{l});
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = l;
    }
}

