/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.googledrive;

import com.deltopia.StringUtil;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileSystem;

public final class GoogleFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String PREFIX = GoogleFileSystemConfigBuilder.class.getName();
    private static final String ACCESS_TOKEN = String.valueOf(PREFIX) + ".ACCESS_TOKEN";
    private static final String APP_NAME = String.valueOf(PREFIX) + ".APP_NAME";
    private static final String CLIENT_ID = String.valueOf(PREFIX) + ".CLIENT_ID";
    private static final String CLIENT_SECRET = String.valueOf(PREFIX) + ".CLIENT_SECRET";
    private static final String DELETE_IN_TRASH = String.valueOf(PREFIX) + ".DELETE_IN_TRASH";
    private static final GoogleFileSystemConfigBuilder INSTANCE = new GoogleFileSystemConfigBuilder();
    private static final String JSON_FACTORY = String.valueOf(PREFIX) + ".JSON_FACTORY";
    private static final String REFRESH_TOKEN = String.valueOf(PREFIX) + ".REFRESH_TOKEN";
    private static final String TRANSPORT = String.valueOf(PREFIX) + ".TRANSPORT";
    private final JsonFactory defJsonFactory;
    private final NetHttpTransport defTransport;

    public static GoogleFileSystemConfigBuilder getInstance() {
        return INSTANCE;
    }

    private GoogleFileSystemConfigBuilder() {
        super("google.");
        try {
            this.defTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Cannot create default protocol", exception);
        }
        this.defJsonFactory = JacksonFactory.getDefaultInstance();
    }

    public String getAccessToken(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, ACCESS_TOKEN);
    }

    public String getAppName(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, APP_NAME);
    }

    public String getClientId(FileSystemOptions fileSystemOptions) {
        return this.getStrObl(fileSystemOptions, CLIENT_ID);
    }

    public String getClientSecret(FileSystemOptions fileSystemOptions) {
        return this.getStrObl(fileSystemOptions, CLIENT_SECRET);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return GoogleFileSystem.class;
    }

    public boolean getDeleteInTrash(FileSystemOptions fileSystemOptions) {
        return this.getBoolean(fileSystemOptions, DELETE_IN_TRASH, true);
    }

    public JsonFactory getJsonFactory(FileSystemOptions fileSystemOptions) {
        JsonFactory jsonFactory = (JsonFactory)this.getParam(fileSystemOptions, JSON_FACTORY);
        return jsonFactory != null ? jsonFactory : this.defJsonFactory;
    }

    public String getRefreshToken(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, REFRESH_TOKEN);
    }

    private String getStrObl(FileSystemOptions fileSystemOptions, String string) {
        String string2 = (String)this.getParam(fileSystemOptions, string);
        if (string2 == null) {
            throw new IllegalStateException("Key was not set " + string);
        }
        return string2;
    }

    public HttpTransport getTransport(FileSystemOptions fileSystemOptions) {
        HttpTransport httpTransport = (HttpTransport)this.getParam(fileSystemOptions, TRANSPORT);
        return httpTransport != null ? httpTransport : this.defTransport;
    }

    public void setAccessToken(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, ACCESS_TOKEN, StringUtil.isEmpty((String)string) ? null : string);
    }

    public void setAppName(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, APP_NAME, string);
    }

    public void setClientId(FileSystemOptions fileSystemOptions, String string) {
        this.setStrObl(fileSystemOptions, CLIENT_ID, string);
    }

    public void setClientSecret(FileSystemOptions fileSystemOptions, String string) {
        this.setStrObl(fileSystemOptions, CLIENT_SECRET, string);
    }

    public void setDeleteInTrash(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, DELETE_IN_TRASH, bl);
    }

    public void setJsonFactory(FileSystemOptions fileSystemOptions, JsonFactory jsonFactory) {
        this.setParam(fileSystemOptions, JSON_FACTORY, jsonFactory);
    }

    public void setRefreshToken(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, REFRESH_TOKEN, StringUtil.isEmpty((String)string) ? null : string);
    }

    private void setStrObl(FileSystemOptions fileSystemOptions, String string, String string2) {
        if (fileSystemOptions == null) {
            throw new NullPointerException("options");
        }
        if (StringUtil.isEmpty((String)string2)) {
            throw new IllegalArgumentException("Invalid " + string + "=" + string2);
        }
        this.setParam(fileSystemOptions, string, string2);
    }

    public void setTransport(FileSystemOptions fileSystemOptions, HttpTransport httpTransport) {
        this.setParam(fileSystemOptions, TRANSPORT, httpTransport);
    }
}

